/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.GSResource;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.ThirdIDAT;
import smart_gs.logical.URICreator;
import smart_gs.logical.visitor.Visitor;
import sml_editor.parser.SMLParser;

public abstract class IDAT
extends SmartDocument {
    protected Spread spread;
    protected String nameToDisplay = null;

    public String getNameToDisplay() {
        return this.nameToDisplay;
    }

    public void setNameToDisplay(String nameToDisplay) {
        this.nameToDisplay = nameToDisplay;
    }

    public IDAT(String uri, String originalURI, String version) {
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public IDAT(Spread spread, String uri, String originalURI, String version) {
        this.spread = spread;
        this.source = "<xml><html></html></xml>";
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public IDAT(Spread spread) {
        this.spread = spread;
        this.source = "<xml><html></html></xml>";
        this.setURIs();
    }

    public Spread getSpread() {
        return this.spread;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public abstract int getType();

    public GSResource getTextSegmentByURI(String uri) {
        int i = 0;
        while (i < this.segments.size()) {
            if (((TextSegment)this.segments.get(i)).getURI().equals(uri)) {
                return (GSResource)this.segments.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setSpread(Spread spread) {
        this.spread = spread;
        this.confirmSegments();
    }

    private void confirmSegments() {
        try {
            Document doc = SMLParser.parse(this.source);
            this.checkSegments(doc.getDocumentElement());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public abstract String getExtension();

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    public int getIDATIndex() {
        if (this instanceof FirstIDAT) {
            return 1;
        }
        if (this instanceof SecondIDAT) {
            return 2;
        }
        if (this instanceof ThirdIDAT) {
            return 3;
        }
        return -1;
    }
}

