/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.LineSegmentsView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class LineSegment
extends Region {
    public LineSegment(Spread spread, List<Point2D> points, String uri, String originalURI, int index) {
        super(spread, "linesegment");
        this.points = points;
        this.createView(index);
        this.setURIs(uri, originalURI);
    }

    private void createView(int index) {
        ArrayList<ExLine2D> lines = new ArrayList<ExLine2D>();
        int i = 0;
        while (i < this.points.size() - 1) {
            Point2D start = (Point2D)this.points.get(i);
            Point2D end = (Point2D)this.points.get(i + 1);
            ExLine2D line = new ExLine2D(start, end);
            lines.add(line);
            ++i;
        }
        this.view = new LineSegmentsView(lines, index);
    }

    public LineSegment(Spread spread, List<Point2D> points) {
        super(spread, "linesegment");
        this.points = points;
        this.createView();
        this.setURIs();
    }

    private void createView() {
        ArrayList<ExLine2D> lines = new ArrayList<ExLine2D>();
        int i = 0;
        while (i < this.points.size() - 1) {
            Point2D start = (Point2D)this.points.get(i);
            Point2D end = (Point2D)this.points.get(i + 1);
            ExLine2D line = new ExLine2D(start, end);
            lines.add(line);
            ++i;
        }
        this.view = new LineSegmentsView(lines);
    }

    @Override
    public Spread getSpread() {
        return this.spread;
    }

    @Override
    public List<Point2D> getPoints() {
        return this.points;
    }

    @Override
    public View getView() {
        return this.view;
    }

    public void changeSize(double m) {
        List<Point2D> points = this.getPoints();
        int i = 0;
        while (i < points.size()) {
            Point2D point = points.get(i);
            double x = point.getX() * m;
            double y = point.getY() * m;
            point.setLocation(x, y);
            ++i;
        }
        int index = this.getView().getIndex();
        this.createView(index);
    }

    public void slideLine(double x1, double y1) {
        List<Point2D> points = this.getPoints();
        int i = 0;
        while (i < points.size()) {
            Point2D point = points.get(i);
            double x = point.getX() + x1;
            double y = point.getY() + y1;
            point.setLocation(x, y);
            ++i;
        }
        int index = this.getView().getIndex();
        this.createView(index);
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        int i = 0;
        while (i < this.points.size() - 1) {
            int x = (int)((Point2D)this.points.get(i)).getX();
            int y = (int)((Point2D)this.points.get(i)).getY();
            polygon.addPoint(x, y);
            ++i;
        }
        return polygon;
    }

    public void addPoint(Point2D point) {
        ArrayList<ExLine2D> lines = new ArrayList<ExLine2D>();
        int i = 0;
        while (i < this.points.size() - 1) {
            Point2D start = (Point2D)this.points.get(i);
            Point2D end = (Point2D)this.points.get(i + 1);
            ExLine2D line = new ExLine2D(start, end);
            lines.add(line);
            ++i;
        }
        double dist = ((ExLine2D)lines.get(0)).ptLineDist(point);
        int x = 0;
        int i2 = 1;
        while (i2 < lines.size()) {
            Double d = ((ExLine2D)lines.get(i2)).ptLineDist(point);
            if (d < dist) {
                dist = d;
                x = i2;
            }
            ++i2;
        }
        this.points.add(x + 1, point);
        int index = this.getView().getIndex();
        this.createView(index);
    }
}

