/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class Sheet {
    private Spread parent;
    private String sheetName = "defaultSheet";
    public static final int SHOW_ALL_REGIONS = 0;
    public static final int SHOW_PROTECTED_REGIONS = 1;
    public static final int SHOW_NO_REGIONS = 2;
    private int showRegion = 0;
    private List<Region> regions;

    public Sheet(List<Region> regions, Spread parent) {
        this.regions = regions;
        this.parent = parent;
    }

    public Sheet(List<Region> regions, Spread parent, String sheetName) {
        this(regions, parent);
        this.sheetName = sheetName;
    }

    public List<Region> getAllRegions() {
        return this.regions;
    }

    public List<Region> getProtectedRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        int i = 0;
        while (i < this.regions.size()) {
            if (this.regions.get(i).isProtected().equals("protected")) {
                regions.add(this.regions.get(i));
            }
            ++i;
        }
        return regions;
    }

    public List<Region> getNormalRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        int i = 0;
        while (i < this.regions.size()) {
            if (this.regions.get(i).isProtected().equals("normal")) {
                regions.add(this.regions.get(i));
            }
            ++i;
        }
        return regions;
    }

    public void addRegion(Region region) {
        this.regions.add(region);
    }

    public int getShowRegion() {
        return this.showRegion;
    }

    public void setShowRegion(int showRegion) {
        this.showRegion = showRegion;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Spread getParent() {
        return this.parent;
    }
}

