/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.ThirdIDAT;
import smart_gs.logical.URICreator;
import smart_gs.logical.URISolver;
import smart_gs.logical.visitor.Visitor;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.XMLToLineConverter;

public class Spread
extends GSResource {
    private SpreadDirectory spreadDirParent;
    private ImageIcon imageIcon;
    private int width;
    private int height;
    private File imageFile;
    private File dscLineSegFile;
    private File lineSegFile;
    private List<LineSegment> lines;
    private List<LineSegment> linesForDsc;
    private List<Region> regions = new ArrayList<Region>();
    private List<Sheet> sheets;
    private Sheet currentSheet;
    protected File dscFile;
    private FirstIDAT firstIDAT;
    private SecondIDAT secondIDAT;
    private ThirdIDAT thirdIDAT;
    private String firstIDATName = null;
    private String secondIDATName = null;
    private String thirdIDATName = null;
    public static String IMAGE_FOLDER_PATH = Preference.getInstance().getImageFolderPathString();
    public static String DSC_FOLDER_PATH = Preference.getInstance().getDscFolderPathString();
    private String writer = "unknown";
    private static int index = 0;
    private static int pageIndex = 0;
    private int _pageIndex;
    private int _pageVIewIndex;
    private ImageLabel imageLabel;
    private double aFromDscToImg;
    private double xFromDscToImg;
    private double yFromDscToImg;
    private double aFromImgToDsc;
    private double xFromImgToDsc;
    private double yFromImgToDsc;
    private boolean transformationIsNecessary = false;

    public String getFirstIDATName() {
        if (this.firstIDATName != null) {
            return this.firstIDATName;
        }
        return Preference.getInstance().getFirstIDATName();
    }

    public String getFirstIDATNameToSave() {
        if (this.firstIDATName != null) {
            return this.firstIDATName;
        }
        return "";
    }

    public void setFirstIDATName(String firstIDATName) {
        this.firstIDATName = firstIDATName.equals("") ? null : firstIDATName;
    }

    public String getSecondIDATName() {
        if (this.secondIDATName != null) {
            return this.secondIDATName;
        }
        return Preference.getInstance().getSecondIDATName();
    }

    public String getSecondIDATNameToSave() {
        if (this.secondIDATName != null) {
            return this.secondIDATName;
        }
        return "";
    }

    public void setSecondIDATName(String secondIDATName) {
        this.secondIDATName = secondIDATName.equals("") ? null : secondIDATName;
    }

    public String getThirdIDATName() {
        if (this.thirdIDATName != null) {
            return this.thirdIDATName;
        }
        return Preference.getInstance().getThirdIDATName();
    }

    public String getThirdIDATNameToSave() {
        if (this.thirdIDATName != null) {
            return this.thirdIDATName;
        }
        return "";
    }

    public void setThirdIDATName(String thirdIDATName) {
        this.thirdIDATName = thirdIDATName.equals("") ? null : thirdIDATName;
    }

    public void printGSEditorMemory() {
    }

    public Spread(SpreadDirectory parent, File file, String uri, String originalURI, String version) {
        this.spreadDirParent = parent;
        this.imageFile = file;
        this.setURIs(uri, originalURI);
        this.setVersion(version);
        this.dscLineSegFile = new File(String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + "dsc/" + this.getFileNameWithoutExtension() + ".xml");
        this.lineSegFile = new File(String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + this.getFileNameWithoutExtension() + ".xml");
        this.firstIDAT = new FirstIDAT(this);
        this.secondIDAT = new SecondIDAT(this);
        this.thirdIDAT = new ThirdIDAT(this);
        this.checkDscFile();
        this.loadLines();
        this.loadLinesForDsc();
        this.setTransformations();
        this.setId(this.hashCode());
        this.sheets = new ArrayList<Sheet>();
        this.currentSheet = this.makeSheet();
        this._pageIndex = pageIndex++;
        this._pageVIewIndex = this._pageIndex;
        this.name = this.getFileNameWithoutExtension();
    }

    public boolean isTransformationIsNecessary() {
        return this.transformationIsNecessary;
    }

    public void setTransformationIsNecessary(boolean transformationIsNecessary) {
        this.transformationIsNecessary = transformationIsNecessary;
    }

    public void setTransformations() {
        if (this.dscLineSegFile.exists() && this.lineSegFile.exists()) {
            Point2D u_v_PointOfLines = this.linesForDsc.get(0).getPoints().get(0);
            Point2D u1_v1_PointOfLines = this.lines.get(0).getPoints().get(0);
            Point2D s_t_PointOfLines = this.linesForDsc.get(0).getPoints().get(1);
            Point2D s1_t1_PointOfLines = this.lines.get(0).getPoints().get(1);
            double u = u_v_PointOfLines.getX();
            double v = u_v_PointOfLines.getY();
            double s = s_t_PointOfLines.getX();
            double t = s_t_PointOfLines.getY();
            double u1 = u1_v1_PointOfLines.getX();
            double v1 = u1_v1_PointOfLines.getY();
            double s1 = s1_t1_PointOfLines.getX();
            double t1 = s1_t1_PointOfLines.getY();
            this.aFromDscToImg = u != s ? (u1 - s1) / (u - s) : (v1 - t1) / (v - t);
            this.xFromDscToImg = s1 - this.aFromDscToImg * s;
            this.yFromDscToImg = t1 - this.aFromDscToImg * t;
            this.aFromImgToDsc = u1 != s1 ? (u - s) / (u1 - s1) : (v - t) / (v1 - t1);
            this.xFromImgToDsc = s - this.aFromImgToDsc * s1;
            this.yFromImgToDsc = t - this.aFromImgToDsc * t1;
            this.setTransformationIsNecessary(true);
        }
    }

    public AffineTransform getAffineTranformFromDscToImg() {
        return new AffineTransform(this.aFromDscToImg, 0.0, 0.0, this.aFromDscToImg, this.xFromDscToImg, this.yFromDscToImg);
    }

    public AffineTransform getAffineTranformFromImgToDsc() {
        return new AffineTransform(this.aFromImgToDsc, 0.0, 0.0, this.aFromImgToDsc, this.xFromImgToDsc, this.yFromImgToDsc);
    }

    public Spread(SpreadDirectory parent, File file) {
        this.spreadDirParent = parent;
        this.imageFile = file;
        this.setURIs();
        this.dscLineSegFile = new File(String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + "dsc/" + this.getFileNameWithoutExtension() + ".xml");
        this.lineSegFile = new File(String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + this.getFileNameWithoutExtension() + ".xml");
        this.firstIDAT = new FirstIDAT(this);
        this.secondIDAT = new SecondIDAT(this);
        this.thirdIDAT = new ThirdIDAT(this);
        this.checkDscFile();
        this.loadLines();
        this.loadLinesForDsc();
        this.setTransformations();
        this.setId(this.hashCode());
        this.sheets = new ArrayList<Sheet>();
        this.currentSheet = this.makeSheet();
        this._pageIndex = pageIndex++;
        this._pageVIewIndex = this._pageIndex;
        this.name = this.getFileNameWithoutExtension();
    }

    public static String getFileNameWithoutExtension(File file) {
        String str = file.getName();
        int index = str.lastIndexOf(46);
        return str.substring(0, index);
    }

    public File getFile() {
        return this.imageFile;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public File getDscLineSegFile() {
        return this.dscLineSegFile;
    }

    public File getLineSegFile() {
        return this.lineSegFile;
    }

    public void loadLines() {
        if (this.lines == null) {
            String filename = String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + this.getFileNameWithoutExtension() + ".xml";
            File file = new File(filename);
            if (!file.exists()) {
                this.lines = new ArrayList<LineSegment>();
                return;
            }
            this.lines = new XMLToLineConverter(this).getLines(new File(filename));
        }
    }

    public void loadLinesForDsc() {
        if (this.linesForDsc == null) {
            String filename = String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + "dsc/" + this.getFileNameWithoutExtension() + ".xml";
            File file = new File(filename);
            if (!file.exists()) {
                this.linesForDsc = new ArrayList<LineSegment>();
                return;
            }
            this.linesForDsc = new XMLToLineConverter(this).getLines(new File(filename));
        }
    }

    void loadImage() {
        File file = new File(this.imageFile.getAbsolutePath());
        this.imageIcon = !file.exists() || !file.isFile() ? new ImageIcon(new File("./icons/no_image_found_large.png").getAbsolutePath()) : new ImageIcon(this.imageFile.getAbsolutePath());
        this.width = this.imageIcon.getIconWidth();
        this.height = this.imageIcon.getIconHeight();
        if (this.width < 0 || this.height < 0) {
            this.imageIcon = null;
            return;
        }
    }

    public int getWidth() {
        if (this.imageIcon == null) {
            this.loadImage();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.imageIcon == null) {
            this.loadImage();
        }
        return this.height;
    }

    public Image getImage() {
        if (this.imageIcon == null) {
            this.loadImage();
        }
        if (this.imageIcon != null) {
            return this.imageIcon.getImage();
        }
        return null;
    }

    public ImageIcon getImageIcon() {
        if (this.imageIcon == null) {
            this.loadImage();
        }
        return this.imageIcon;
    }

    public void addRegion(Region region) {
        this.regions.add(region);
        this.currentSheet.addRegion(region);
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public List<Region> getAllRegions() {
        return this.currentSheet.getAllRegions();
    }

    public void addLineSegment(LineSegment line) {
        this.lines.add(line);
    }

    public List<LineSegment> getLines() {
        if (this.lines == null) {
            this.loadLines();
        }
        return this.lines;
    }

    public List<LineSegment> getLinesForDsc() {
        if (this.linesForDsc == null) {
            this.loadLinesForDsc();
        }
        return this.linesForDsc;
    }

    public void changeLinesSize(double mag) {
        double m = mag / 100.0;
        List<LineSegment> lines = this.getLines();
        int i = 0;
        while (i < lines.size()) {
            lines.get(i).changeSize(m);
            ++i;
        }
        WorkspaceWindow.getInstance().repaint();
    }

    public void slideLines(double x, double y) {
        List<LineSegment> lines = this.getLines();
        int i = 0;
        while (i < lines.size()) {
            lines.get(i).slideLine(x, y);
            ++i;
        }
        WorkspaceWindow.getInstance().repaint();
    }

    public SpreadDirectory getSpreadDirParent() {
        return this.spreadDirParent;
    }

    public String getFileNameWithoutExtension() {
        int index = this.imageFile.getName().lastIndexOf(46);
        return this.imageFile.getName().substring(0, index);
    }

    public String getFileNameExtension() {
        int index = this.imageFile.getName().lastIndexOf(46);
        return this.imageFile.getName().substring(index + 1);
    }

    public String getFileName() {
        return this.imageFile.getName();
    }

    @Override
    public String toString() {
        String str = String.valueOf(this._pageVIewIndex) + ": " + this.name;
        if (this.dscLineSegFile.exists() && this.lineSegFile.exists()) {
            str = String.valueOf(str) + "  [**]";
        } else if (this.dscFile != null) {
            str = String.valueOf(str) + "  [*]";
        }
        return str;
    }

    public String getViewName() {
        String str = String.valueOf(this._pageVIewIndex) + ": " + this.name;
        if (this.dscLineSegFile.exists() && this.lineSegFile.exists()) {
            str = String.valueOf(str) + "  [**]";
        } else if (this.dscFile != null) {
            str = String.valueOf(str) + "  [*]";
        }
        return str;
    }

    public FirstIDAT getFirstIDAT() {
        return this.firstIDAT;
    }

    public SecondIDAT getSecondIDAT() {
        return this.secondIDAT;
    }

    public ThirdIDAT getThirdIDAT() {
        return this.thirdIDAT;
    }

    public void setFirstIDAT(FirstIDAT fstidat) {
        this.firstIDAT = fstidat;
    }

    public void setSecondIDAT(SecondIDAT sndidat) {
        this.secondIDAT = sndidat;
    }

    public void setThirdIDAT(ThirdIDAT thdidat) {
        this.thirdIDAT = thdidat;
    }

    public boolean hasDscFile() {
        return this.dscFile != null;
    }

    public List<Region> getSelectedRegions() {
        ArrayList<Region> results = new ArrayList<Region>();
        int i = 0;
        while (i < this.regions.size()) {
            View view = this.regions.get(i).getView();
            if (view.isSelected()) {
                results.add(this.regions.get(i));
            }
            ++i;
        }
        return results;
    }

    public void clearSelection() {
        int i = 0;
        while (i < this.regions.size()) {
            View view = this.regions.get(i).getView();
            view.setIsSelected(false);
            view.setIsEmphasized(false);
            ++i;
        }
    }

    public void checkDscFile() {
        String folderPath = String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + "/dsc/";
        this.dscFile = new File(String.valueOf(folderPath) + this.getFileNameWithoutExtension() + ".dsc");
        if (!this.dscFile.exists()) {
            this.dscFile = null;
        }
    }

    public File getDscFile() {
        String folderPath = String.valueOf(DSC_FOLDER_PATH) + this.spreadDirParent.getPath() + "/dsc/";
        this.dscFile = new File(String.valueOf(folderPath) + this.getFileNameWithoutExtension() + ".dsc");
        if (!this.dscFile.exists()) {
            this.dscFile = null;
            return null;
        }
        return this.dscFile;
    }

    public void removeRegion(Region region) {
        this.regions.remove(region);
    }

    public void release() {
        if (Preference.getInstance().shouldLoadAll()) {
            return;
        }
        if (this.imageIcon == null) {
            return;
        }
        this.imageIcon.getImage().flush();
        this.imageIcon = null;
    }

    public Region getRegionByURI(String uri) {
        int i = 0;
        while (i < this.regions.size()) {
            if (this.regions.get(i).getURI().equals(uri)) {
                return this.regions.get(i);
            }
            ++i;
        }
        return null;
    }

    public GSResource getResource(String uri) {
        if (this.uri.equals(uri)) {
            return this;
        }
        if (this.firstIDAT.uri.equals(uri)) {
            return this.firstIDAT;
        }
        if (this.thirdIDAT.uri.equals(uri)) {
            return this.thirdIDAT;
        }
        if (this.secondIDAT.uri.equals(uri)) {
            return this.secondIDAT;
        }
        if (URISolver.isATextSegmentFromFirstIDAT(uri)) {
            return this.firstIDAT.getTextSegmentByURI(uri);
        }
        if (URISolver.isATextSegmentFromSecondIDAT(uri)) {
            return this.secondIDAT.getTextSegmentByURI(uri);
        }
        if (URISolver.isATextSegmentFromThirdIDAT(uri)) {
            return this.thirdIDAT.getTextSegmentByURI(uri);
        }
        return this.getRegionByURI(uri);
    }

    public String getFolderPath() {
        return this.spreadDirParent.getPath();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String getWriter() {
        return this.writer;
    }

    public void setWriter(String writer) {
        this.writer = writer;
    }

    public void showRegions() {
        if (this.currentSheet.getShowRegion() == 1) {
            this.regions = this.currentSheet.getProtectedRegions();
        } else if (this.currentSheet.getShowRegion() == 2) {
            this.regions = new ArrayList<Region>();
        } else if (this.currentSheet.getShowRegion() == 0) {
            this.regions = this.currentSheet.getAllRegions();
        }
    }

    public void changeShowRegionAttribute() {
        if (this.currentSheet.getShowRegion() == 2) {
            this.currentSheet.setShowRegion(0);
        } else if (this.currentSheet.getShowRegion() == 0) {
            this.currentSheet.setShowRegion(1);
        } else if (this.currentSheet.getShowRegion() == 1) {
            this.currentSheet.setShowRegion(2);
        }
    }

    public void changeShowRegion(int showRegion) {
        this.currentSheet.setShowRegion(showRegion);
        this.showRegions();
    }

    public Sheet makeSheet() {
        ArrayList<Region> regions = new ArrayList<Region>();
        Sheet sheet = new Sheet(regions, this);
        if (this.sheets.size() != 0) {
            this.setNewSheetName(sheet);
        }
        this.sheets.add(sheet);
        return sheet;
    }

    public void _selectSheet(Sheet sheet) {
        this.currentSheet = sheet;
        this.showRegions();
    }

    public void roundSheet() {
        int i = this.sheets.indexOf(this.currentSheet);
        if (i + 1 < this.sheets.size()) {
            this._selectSheet(this.sheets.get(i + 1));
        } else {
            this._selectSheet(this.sheets.get(0));
        }
    }

    public void setNewSheetName(Sheet sheet) {
        String sheetName = JOptionPane.showInputDialog("Input sheet name");
        sheet.setSheetName(sheetName);
    }

    public List<Sheet> getSheets() {
        return this.sheets;
    }

    public Sheet getCurrentSheet() {
        return this.currentSheet;
    }

    public void setCurrentSheet(Sheet sheet) {
        this.currentSheet = sheet;
    }

    public static void resetIndex() {
        pageIndex = 0;
    }

    public static Integer getCurrentMaxPageIndex() {
        return pageIndex;
    }

    public void setPageViewIndex(int number) {
        this._pageVIewIndex = number;
    }

    public int getPageViewIndex() {
        return this._pageVIewIndex;
    }

    public int getPageIndex() {
        return this._pageIndex;
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "spread";
    }

    public String createOldVersionURI() {
        return "smart://" + this.spreadDirParent.createOldVersionURI() + Spread.getFileNameWithoutExtension(this.imageFile) + "/";
    }

    public IDAT getIDATByTextSegmentURI(String uri) {
        if (uri.contains("firstIdat") || uri.contains("/transcription/")) {
            return this.firstIDAT;
        }
        if (uri.contains("secondIdat") || uri.contains("/annotation/")) {
            return this.secondIDAT;
        }
        if (uri.contains("thirdIdat") || uri.contains("/translation/")) {
            return this.thirdIDAT;
        }
        return null;
    }
}

