/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import smart_gs.logical.GSResource;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.URICreator;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.logical.visitor.Visitor;
import smart_gs.util.GSStandardPath;

public class SpreadDirectory
extends GSResource {
    private File imageFolder;
    private List<GSResource> resources;
    private SpreadDirectory parent;

    public SpreadDirectory(String name, File imageFolder, String uri, String originalURI, String version) {
        this.name = name;
        this.parent = null;
        this.imageFolder = imageFolder;
        this.resources = new ArrayList<GSResource>();
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public List<GSResource> getResources() {
        return this.resources;
    }

    public void setResources(List<GSResource> newResources) {
        this.resources = newResources;
    }

    public SpreadDirectory(SpreadDirectory parent, String name, File file, String uri, String originalURI, String version) {
        this.name = name;
        this.parent = parent;
        this.imageFolder = file;
        this.resources = new ArrayList<GSResource>();
        this.setURIs(uri, originalURI);
        this.setVersion(version);
    }

    public SpreadDirectory(String name, File imageFolder) {
        this.name = name;
        this.parent = null;
        this.imageFolder = imageFolder;
        this.resources = new ArrayList<GSResource>();
        this.setURIs();
    }

    public SpreadDirectory(SpreadDirectory parent, String name, File file) {
        this.name = name;
        this.parent = parent;
        this.imageFolder = file;
        this.resources = new ArrayList<GSResource>();
        this.setURIs();
    }

    public List<Spread> getSpreads() {
        ArrayList<Spread> results = new ArrayList<Spread>();
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof Spread) {
                results.add((Spread)resource);
            } else if (resource instanceof SpreadDirectory) {
                results.addAll(((SpreadDirectory)resource).getSpreads());
            }
            ++i;
        }
        return results;
    }

    public List<SpreadDirectory> getSpreadDirectorys() {
        ArrayList<SpreadDirectory> results = new ArrayList<SpreadDirectory>();
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof SpreadDirectory) {
                results.add((SpreadDirectory)resource);
                results.addAll(((SpreadDirectory)resource).getSpreadDirectorys());
            }
            ++i;
        }
        return results;
    }

    public void addResource(GSResource resource) {
        this.resources.add(resource);
    }

    public File getFile() {
        return this.imageFolder;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getPath() {
        String path = "";
        if (this.parent == null) {
            return path;
        }
        path = this.parent.getPath();
        return String.valueOf(path) + this.getName() + "/";
    }

    public void restore(Element element, File parentPath) {
        this.resources.clear();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element elem = (Element)node;
                String tagname = elem.getNodeName();
                if (tagname.equals("spread")) {
                    Spread spread = XML2ResourceConverter.getSpread(this, parentPath, elem);
                    SpreadTree.getInstance().registorSpread(spread);
                    this.addResource(spread);
                } else if (tagname.equals("directory")) {
                    String name = elem.getAttribute("name");
                    String uri = elem.getAttribute("uri");
                    String originalURI = elem.getAttribute("originalURI");
                    String version = elem.getAttribute("version");
                    String[] token = GSStandardPath.standardizeDirName(elem.getAttribute("filename")).split("/");
                    String dirname = token[token.length - 1];
                    File dirpath = new File(parentPath, dirname);
                    SpreadDirectory directory = new SpreadDirectory(this, name, dirpath, uri, originalURI, version);
                    SpreadTree.getInstance().registorSpreadDirectory(directory);
                    this.addResource(directory);
                    directory.setURI(uri);
                    directory.restore(elem, dirpath);
                }
            }
            ++i;
        }
    }

    public void setTree(DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof Spread) {
                parent.add(new DefaultMutableTreeNode(resource));
            } else if (resource instanceof SpreadDirectory) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(resource);
                parent.add(newNode);
                ((SpreadDirectory)resource).setTree(newNode);
            }
            ++i;
        }
    }

    public void remove(Spread spread) {
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof Spread) {
                if (resource.getURI().equals(spread.getURI())) {
                    this.resources.remove(i);
                    break;
                }
            } else if (resource instanceof SpreadDirectory) {
                ((SpreadDirectory)resource).remove(spread);
            }
            ++i;
        }
    }

    public void removeDirectory(SpreadDirectory spreadDirectory) {
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof SpreadDirectory) {
                if (resource.getURI().equals(spreadDirectory.getURI())) {
                    this.resources.remove(i);
                    break;
                }
                ((SpreadDirectory)resource).removeDirectory(spreadDirectory);
            }
            ++i;
        }
    }

    public void removeAllChildren() {
        int i = 0;
        while (i < this.resources.size()) {
            GSResource resource = this.resources.get(i);
            if (resource instanceof Spread) {
                this.resources.remove(i);
            } else if (resource instanceof SpreadDirectory) {
                ((SpreadDirectory)resource).removeAllChildren();
                this.resources.remove(i);
            }
            ++i;
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void sort() {
        Collections.sort(this.resources, new Comparator<GSResource>(){

            @Override
            public int compare(GSResource o1, GSResource o2) {
                if (o1 instanceof Spread && o2 instanceof Spread) {
                    if (((Spread)o1).getPageViewIndex() > ((Spread)o2).getPageViewIndex()) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "directory";
    }

    public SpreadDirectory getParent() {
        return this.parent;
    }

    public String createOldVersionURI() {
        if (this.parent == null) {
            return "smart://";
        }
        return String.valueOf(this.parent.createOldVersionURI()) + this.name + File.separator;
    }
}

