/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical.visitor;

import javax.swing.JOptionPane;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.TextSegment;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteDirectory;
import smart_gs.logical.Zombie;
import smart_gs.logical.visitor.Visitor;
import smart_gs.menu.action.ResourceListSelectionFrame;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTextEditor;

public class ShowResourceVisitor
implements Visitor {
    @Override
    public void visit(Spread spread) {
        new GSEditor(spread).setVisible(true);
    }

    @Override
    public void visit(Region region) {
        new GSEditor(region).setVisible(true);
    }

    @Override
    public void visit(IDAT iDAT) {
        Spread spread = iDAT.getSpread();
        GSEditor editor = new GSEditor(spread);
        editor.setVisible(true);
    }

    @Override
    public void visit(TextSegment segment) {
        SmartDocument document = segment.getDocument();
        int id = segment.getId();
        if (document instanceof IDAT) {
            GSEditor editor = new GSEditor(((IDAT)document).getSpread());
            editor.getSMLTabbedPane().setPanelToShow(((IDAT)document).getType());
            editor.updateText();
            editor.setVisible(true);
            editor.emphasize(String.valueOf(id));
        } else if (document instanceof GSExplanatoryNote) {
            ((GSExplanatoryNote)document).show();
        } else {
            GSTextEditor editor = new GSTextEditor(document);
            editor.setSize(800, 600);
            editor.setTitle(document.getName());
            editor.setVisible(true);
            editor.emphasize(String.valueOf(id));
        }
    }

    @Override
    public void visit(SpreadDirectory directory) {
        JOptionPane.showMessageDialog(null, "No way to show");
    }

    @Override
    public void visit(StandardTextDocument textDocument) {
        new GSTextEditor(textDocument).setVisible(true);
    }

    @Override
    public void visit(GSExplanatoryNote note) {
        System.out.println("_");
    }

    @Override
    public void visit(UsersNote usersNote) {
        new GSTextEditor(usersNote).setVisible(true);
    }

    @Override
    public void visit(UsersNoteDirectory usersNoteDirectory) {
        JOptionPane.showMessageDialog(null, "No way to show");
    }

    @Override
    public void visit(Zombie zombie) {
        JOptionPane.showMessageDialog(null, "Zombie of " + zombie.getDeadURI());
    }

    @Override
    public void visit(ResourceBasket resourceBasket) {
        new ResourceListSelectionFrame(resourceBasket).showResourceSelectionFrame();
    }
}

