/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.desktop.logical;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSVersion;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopFolderView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.WorkspaceWindow;

public class DeskTopFolder
extends DesktopElement
implements URIBearer {
    private String uri;
    private String originalURI;
    private String oldVersionURI;
    private String version;
    private List<ShortCut> shortcuts;
    private List<DeskTopFolder> folders;

    public DeskTopFolder(DeskTopFolder parent, String name) {
        super(parent, name, "<xml></xml>");
        this.setName(name);
        this.shortcuts = new ArrayList<ShortCut>();
        this.folders = new ArrayList<DeskTopFolder>();
        this.setURIs();
        this.setVersion(GSVersion.getVersion());
    }

    public DeskTopFolder(String name) {
        super(ReasoningWebDesktop.getInstance().getRootFolder(), name, "<xml></xml>");
        this.shortcuts = new ArrayList<ShortCut>();
        this.folders = new ArrayList<DeskTopFolder>();
        this.setURIs();
        this.setVersion(GSVersion.getVersion());
    }

    public void add(DesktopElement element) {
        if (element instanceof ShortCut) {
            this.shortcuts.add((ShortCut)element);
        } else if (element instanceof DeskTopFolder) {
            DeskTopFolder folder = (DeskTopFolder)element;
            this.folders.add(folder);
            folder.setParent(this);
        }
        this.notifyChange();
        ReasoningWebFrame.getInstance().getDesktopPanel().updateAll();
    }

    @Override
    public void setParent(DeskTopFolder parent) {
        this.parent = parent;
    }

    public void updateURI() {
        this.uri = this.createURI();
        List<DeskTopFolder> folders = this.getFolders();
        int i = 0;
        while (i < folders.size()) {
            folders.get(i).updateURI();
            ++i;
        }
    }

    public void remove(DesktopElement desktopelement) {
        if (desktopelement instanceof ShortCut) {
            this.shortcuts.remove((ShortCut)desktopelement);
        } else if (desktopelement instanceof DeskTopFolder) {
            this.folders.remove((DeskTopFolder)desktopelement);
        }
        this.notifyChange();
        WorkspaceWindow.setUpdated(true);
    }

    public void initialize() {
        this.shortcuts.clear();
        this.folders.clear();
    }

    public List<ShortCut> getShortCuts() {
        return this.shortcuts;
    }

    public List<DeskTopFolder> getFolders() {
        return this.folders;
    }

    @Override
    public void open() {
        ReasoningWebFrame.getInstance().setMainPanel(new FolderPanel(this));
    }

    @Override
    public DesktopElementView createView() {
        return new DesktopFolderView();
    }

    public List<DesktopElement> getAllElements() {
        ArrayList<DesktopElement> elements = new ArrayList<DesktopElement>();
        elements.addAll(this.shortcuts);
        elements.addAll(this.folders);
        return elements;
    }

    public DeskTopFolder getFolder(Point point) {
        int i = 0;
        while (i < this.folders.size()) {
            if (this.folders.get(i).getView().contains(point)) {
                return this.folders.get(i);
            }
            ++i;
        }
        return null;
    }

    public DeskTopFolder getFolderOtherThan(Point point, DeskTopFolder folder) {
        int i = 0;
        while (i < this.folders.size()) {
            DeskTopFolder target = this.folders.get(i);
            if (!target.equals(folder) && target.getView().contains(point)) {
                return target;
            }
            ++i;
        }
        return null;
    }

    public DeskTopFolder getFolder(String name) {
        int i = 0;
        while (i < this.folders.size()) {
            if (this.folders.get(i).getName().equals(name)) {
                return this.folders.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Element createXMLElement(Document document) {
        Element elem;
        Element element = document.createElement("desktopFolder");
        element.setAttribute("name", this.name);
        element.setAttribute("uri", this.uri);
        element.setAttribute("originalURI", this.originalURI);
        element.setAttribute("oldVersionURI", this.getOldVersionURI());
        element.setAttribute("version", this.version);
        element.setAttribute("source", this.memo.getSource());
        int i = 0;
        while (i < this.folders.size()) {
            elem = this.folders.get(i).createXMLElement(document);
            element.appendChild(elem);
            ++i;
        }
        i = 0;
        while (i < this.shortcuts.size()) {
            elem = this.shortcuts.get(i).createXMLElement(document);
            element.appendChild(elem);
            ++i;
        }
        return element;
    }

    public static DeskTopFolder restore(Element element) {
        String name = element.getAttribute("name");
        String source = element.getAttribute("source");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        DeskTopFolder folder = new DeskTopFolder(name);
        folder.setString(source);
        folder.setURIs(uri, originalURI);
        folder.setOldVersionURI(oldVersionURI);
        folder.setVersion(version);
        NodeList list = element.getElementsByTagName("desktopFolder");
        int i = 0;
        while (i < list.getLength()) {
            DeskTopFolder childFolder = DeskTopFolder.restore((Element)list.item(i));
            folder.add(childFolder);
            ++i;
        }
        list = element.getElementsByTagName("shortcut");
        i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getParentNode().equals(element)) {
                ShortCut shortcut = ShortCut.restore((Element)list.item(i));
                folder.add(shortcut);
                shortcut.setParent(folder);
            }
            ++i;
        }
        return folder;
    }

    @Override
    public JPanel createElementViewPanel() throws NoWayToShowException {
        throw new NoWayToShowException();
    }

    @Override
    public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
        JPanel panel = new JPanel();
        panel.add(new JLabel("DeskTopFolder"));
        panel.setSize(width, height);
        return panel;
    }

    @Override
    public void show() {
        this.open();
    }

    public boolean hasFolder(String name) {
        int i = 0;
        while (i < this.folders.size()) {
            if (this.folders.get(i).getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GSResource getResource(String uri) {
        GS_RWElement resource;
        int i = 0;
        while (i < this.shortcuts.size()) {
            resource = this.shortcuts.get(i).getResource();
            if (resource.getURI().equals(uri)) {
                return (GSResource)resource;
            }
            resource = this.shortcuts.get(i).getMemo().getSegments(uri);
            if (resource != null) {
                return (GSResource)resource;
            }
            ++i;
        }
        i = 0;
        while (i < this.folders.size()) {
            resource = this.folders.get(i).getResource(uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String createURI() {
        return URICreator.createURI(this);
    }

    @Override
    public String getTypeString() {
        return "desktopFolder";
    }

    @Override
    public void setURIs() {
        this.originalURI = this.createURI();
        this.setURI(this.originalURI);
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setOriginalURI(String originalURI) {
        this.originalURI = originalURI;
    }

    @Override
    public String getOriginalURI() {
        return this.originalURI;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setURIs(String uri, String originalURI) {
        URICreator.setURIs(this, uri, originalURI);
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getOldVersionURI() {
        return this.oldVersionURI;
    }

    @Override
    public void setOldVersionURI(String oldVersionURI) {
        this.oldVersionURI = oldVersionURI;
    }
}

