/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import reasoning_web.logical.Connection;
import reasoning_web.logical.Factory;
import reasoning_web.logical.RWRepository;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.GSResource;
import smart_gs.logical.ResourceBasket;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GSFactory;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.LocalViewFrame;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Quadruple;

public class GS_RWRepository
extends RWRepository {
    private static GS_RWRepository singleton = new GS_RWRepository();
    private String backgroundFilePath = null;

    private GS_RWRepository() {
    }

    public static GS_RWRepository getInstance() {
        return singleton;
    }

    @Override
    protected Factory getFactory() {
        return new GSFactory();
    }

    public ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> getLocalViewInfo(GS_RWElement element) {
        return this.getResourcePointer(element).getLocalViewInfo();
    }

    public void showLocalView(GS_RWElement element) {
        ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> info = this.getResourcePointer(element).getLocalViewInfo();
        new LocalViewFrame(info).setVisible(true);
    }

    public GSResourcePointer getResourcePointer(GS_RWElement element) {
        return (GSResourcePointer)super.getResourcePointer(element);
    }

    public List<RWElement> getDirectElements(RWElement element) {
        return this.getDirectElements(this.getResourcePointer(element));
    }

    public List<RWElement> getAllElements() {
        ArrayList<RWElement> elements = new ArrayList<RWElement>();
        List<ResourcePointer> pointers = this.getResourcePointers();
        int i = 0;
        while (i < pointers.size()) {
            elements.add(pointers.get(i).getRwElement());
            ++i;
        }
        return elements;
    }

    public void restore(Element rwElement) {
        Element background;
        String temp;
        Element desktopElement = (Element)rwElement.getElementsByTagName("desktop").item(0);
        ReasoningWebDesktop.getInstance().restore(desktopElement);
        NodeList connectionList = rwElement.getElementsByTagName("connection");
        int i = 0;
        while (i < connectionList.getLength()) {
            Element element = (Element)connectionList.item(i);
            GSConnection connection = GSConnection.restore(element);
            this.register(connection.getSourcePointer());
            this.register(connection.getTargetPointer());
            this.addConnection(connection);
            ++i;
        }
        this.resourceBaskets.clear();
        NodeList basketList = rwElement.getElementsByTagName("resourceBasket");
        int i2 = 0;
        while (i2 < basketList.getLength()) {
            Element element = (Element)basketList.item(i2);
            ResourceBasket basket = ResourceBasket.restore(element);
            basket.setToBeSaved(true);
            this.addResourceBasket(basket);
            ++i2;
        }
        ResourceBasketsFrame.renew();
        connectionList = rwElement.getElementsByTagName("background");
        if (connectionList.getLength() > 0 && (temp = (background = (Element)connectionList.item(0)).getAttribute("file")) != null && temp.length() > 0) {
            this.backgroundFilePath = temp;
        }
    }

    public void addResourceBasket(ResourceBasket basket) {
        if (!this.resourceBaskets.contains(basket)) {
            this.resourceBaskets.add(basket);
        }
    }

    public void save(Document document, Element parent) {
        Element elem;
        Element element = document.createElement("reasoning_web");
        ReasoningWebDesktop.getInstance().save(document, element);
        int i = 0;
        while (i < this.connections.size()) {
            GSConnection connection = (GSConnection)this.connections.get(i);
            elem = connection.createXMLElement(document);
            element.appendChild(elem);
            ++i;
        }
        i = 0;
        while (i < this.resourceBaskets.size()) {
            ResourceBasket basket = (ResourceBasket)this.resourceBaskets.get(i);
            elem = basket.createXMLElement(document);
            NodeList list = element.getElementsByTagName("resourceBasket");
            boolean contain = false;
            int j = 0;
            while (j < list.getLength()) {
                if (list.item(j).equals(elem)) {
                    contain = true;
                    break;
                }
                ++j;
            }
            if (!contain) {
                element.appendChild(elem);
            }
            ++i;
        }
        parent.appendChild(element);
        if (this.backgroundFilePath != null && this.backgroundFilePath.length() > 0) {
            Element background = document.createElement("background");
            background.setAttribute("file", this.backgroundFilePath);
            element.appendChild(background);
        }
    }

    public void removeConnection(Connection connection) {
        if (connection != null) {
            this.connections.remove(connection);
            connection.getSourcePointer().removeConnection(connection);
            connection.getTargetPointer().removeConnection(connection);
            if (!connection.getSourcePointer().hasConnection()) {
                this.pointers.remove(connection.getSourcePointer());
                WorkspaceWindow.setUpdated(true);
            }
            if (!connection.getTargetPointer().hasConnection()) {
                this.pointers.remove(connection.getTargetPointer());
                WorkspaceWindow.setUpdated(true);
            }
        }
    }

    public void removePointer(ResourcePointer pointer) {
        if (pointer != null) {
            this.pointers.remove(pointer);
        }
    }

    public String getBackgroundFilePath() {
        return this.backgroundFilePath;
    }

    public void setBackgroundFilePath(String backgroundFilePath) {
        this.backgroundFilePath = backgroundFilePath;
    }

    public List<GSResource> getResourceBaskets() {
        return this.resourceBaskets;
    }

    public void deleteResourceFromBaskets(GSResource resource) {
        int i = 0;
        while (i < this.resourceBaskets.size()) {
            ResourceBasket basket = (ResourceBasket)this.resourceBaskets.get(i);
            basket.removeResource(resource);
            ResourceBasketsFrame.getInstance().getSelectionFrame(basket).setBasket(basket);
            ++i;
        }
    }
}

