/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui.mouse_listener;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import reasoning_web.logical.Connection;
import reasoning_web.logical.ResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.reasoning_web.swingui.action.ConnectionRightClickMenu;
import smart_gs.reasoning_web.swingui.action.PointerRightClickMenu;
import smart_gs.reasoning_web.swingui.view.View;
import smart_gs.swingui.WorkspaceWindow;

public class GlobalViewMouseListener
implements MouseListener,
MouseMotionListener {
    private Point2D start = null;
    private Point2D end = null;
    private GS_RWElement selectedElement;
    private View selectedView;
    private final Rectangle rect = new Rectangle();

    @Override
    public void mouseClicked(MouseEvent e) {
        this.start = e.getPoint();
        GS_RWElement element = (GS_RWElement)GlobalViewPanel.getInstance().getElement(e.getPoint());
        if (e.getButton() == 3 || e.getButton() == 1 & WorkspaceWindow.getInstance().isAlt()) {
            ResourcePointer pointer = GlobalViewPanel.getInstance().getResourcePointer(e.getPoint());
            if (pointer != null) {
                PointerRightClickMenu pmenu = new PointerRightClickMenu(pointer);
                pmenu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            } else {
                Connection connection = GlobalViewPanel.getInstance().getConnection(e.getPoint());
                if (connection != null) {
                    ConnectionRightClickMenu cmenu = new ConnectionRightClickMenu((GS_RWElement)((Object)connection));
                    cmenu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        }
        if (element == null) {
            this.selectedElement = null;
            return;
        }
        this.selectedElement = element;
        if (e.getClickCount() == 2) {
            element.show();
            System.out.println(element.getClass());
            return;
        }
        GS_RWRepository.getInstance();
    }

    public GS_RWElement getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(GS_RWElement element) {
        this.selectedElement = element;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.start = e.getPoint();
        if (this.selectedView != null && !this.selectedView.contains(e.getPoint())) {
            this.selectedView.setIsSelected(false);
            this.selectedView = null;
            this.selectedElement = null;
        }
        View view = GlobalViewPanel.getInstance().getView(e.getPoint());
        this.selectedElement = (GS_RWElement)GlobalViewPanel.getInstance().getElement(e.getPoint());
        if (view == null) {
            return;
        }
        view.setIsSelected(true);
        this.selectedView = view;
        ReasoningWebFrame.getInstance().getElementsPanel().setElement(this.selectedElement);
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.start = null;
        this.end = null;
        GlobalViewPanel.getInstance().setCursor(new Cursor(0));
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.end = e.getPoint();
        if (this.selectedView == null) {
            GlobalViewPanel.getInstance().setCursor(new Cursor(12));
            Rectangle r = GlobalViewPanel.getInstance().getVisibleRect();
            this.rect.setRect((double)r.x - this.end.getX() + this.start.getX(), (double)r.y - this.end.getY() + this.start.getY(), r.getWidth(), r.getHeight());
            GlobalViewPanel.getInstance().scrollRectToVisible(this.rect);
            return;
        }
        if (this.end.getX() <= 0.0) {
            this.end.setLocation(5.0, this.end.getY());
        }
        if (this.end.getY() <= 0.0) {
            this.end.setLocation(this.end.getX(), 5.0);
        }
        Point2D.Double point = new Point2D.Double(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
        this.selectedView.moveBy(point);
        this.start = this.end;
        GlobalViewPanel.getInstance().repaint();
        GlobalViewPanel.getInstance().setGlobalViewPanelSize(this.end);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

