/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.action.JumpWebPageAction;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSEditorPopupMenu;
import smart_gs.smleditor.swingui.GSEditorPopupMenu2;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import sml_editor.swingui.wysiwyg.WysiwygMouseListener;

public class GSWysiwygMouseListener
extends WysiwygMouseListener {
    protected boolean markupflg = false;

    public GSWysiwygMouseListener(GSEditorTextPane textPane) {
        super(textPane);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String id;
        SimpleAttributeSet element;
        super.mouseClicked(e);
        if (e.getButton() == 3 || e.getButton() == 1 & WorkspaceWindow.getInstance().isAlt()) {
            element = this.textPane.getSelectID(e.getPoint());
            if (element == null) {
                JComponent component = (JComponent)e.getSource();
                new GSEditorPopupMenu2(this.textPane).show(this.textPane, e.getX() + component.getX(), e.getY() + component.getY());
                return;
            }
            boolean href = false;
            id = (String)element.getAttribute(HTML.Attribute.HREF);
            TextSegment segment = null;
            if (id != null) {
                int checkid = HrefChecker.check(id);
                if (checkid == -1) {
                    href = true;
                } else {
                    segment = ((GSEditorTextPane)this.textPane).getSmartDocument().getSegmentByID(checkid);
                }
                JComponent component = (JComponent)e.getSource();
                new GSEditorPopupMenu(segment, this.textPane, e.getPoint(), href).show(this.textPane, e.getX() + component.getX(), e.getY() + component.getY());
            }
        }
        if (e.getButton() == 1) {
            element = this.textPane.getSelectID(e.getPoint());
            if (element == null) {
                return;
            }
            TextSegment segment = null;
            id = (String)element.getAttribute(HTML.Attribute.HREF);
            int checkid = HrefChecker.check(id);
            if (element.getAttribute("external") != null) {
                new JumpWebPageAction(this.textPane, e.getPoint()).actionPerformed(null);
                return;
            }
            segment = ((GSEditorTextPane)this.textPane).getSmartDocument().getSegmentByID(checkid);
            if (segment != null) {
                if (WorkspaceWindow.getInstance().isAlt() && WorkspaceWindow.getInstance().isCtrl()) {
                    new ShowLocalViewAction(segment).execute();
                } else if (WorkspaceWindow.getInstance().isAlt()) {
                    ConnectionCreator.setSource(segment);
                } else if (WorkspaceWindow.getInstance().isCtrl()) {
                    ConnectionCreator.setTarget(segment);
                }
                if (e.getClickCount() == 2) {
                    new ShowLocalViewAction(segment).execute();
                }
            }
        }
    }
}

