/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.spread_selection.CheckBoxNode;
import smart_gs.spread_selection.SpreadSelectionTree;
import smart_gs.spread_selection.SpreadSelectionTreeDirectoryPopupMenu;
import smart_gs.swingui.WorkspaceWindow;

public class SpreadSelectionTreePanel
extends JPanel
implements MouseListener {
    private SpreadSelectionTree tree;
    private JScrollPane scrollPane;
    private SpreadTree spreadTree = SpreadTree.getInstance();
    MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            int selRow = SpreadSelectionTreePanel.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = SpreadSelectionTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
            int clickCount = e.getClickCount();
            if (selRow != -1 && e.getButton() == 3 && selPath != null) {
                Object lastComponent = selPath.getLastPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastComponent;
                Object userObj = node.getUserObject();
                if (userObj instanceof CheckBoxNode) {
                    Spread spread = SpreadSelectionTreePanel.this.spreadTree.getSpreadByIndex(((CheckBoxNode)userObj).getIndex());
                    if (spread != null && clickCount == 2) {
                        WorkspaceWindow.getInstance().tabbedPaneSave();
                        GSEditor editor = new GSEditor(spread);
                        editor.setVisible(true);
                        return;
                    }
                } else {
                    SpreadSelectionTreeDirectoryPopupMenu menu = new SpreadSelectionTreeDirectoryPopupMenu(SpreadSelectionTreePanel.this.tree, node);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
            }
        }
    };

    public SpreadSelectionTreePanel(SpreadSelectionTree givenTree) {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tree = givenTree;
        this.scrollPane.addMouseListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel tree_panel = new JPanel();
        tree_panel.setLayout(new FlowLayout(0));
        tree_panel.setBackground(Color.white);
        tree_panel.add(this.tree);
        tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.tree.addMouseListener(this);
        panel.add((Component)tree_panel, "Center");
        this.scrollPane.setViewportView(panel);
        this.add((Component)this.scrollPane, "Center");
        this.tree.addMouseListener(this.ml);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

