/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.SpreadFilter;

public class SpreadSelector {
    private String spreadSelection;
    private List<Spread> allSpreads;
    private List<int[]> indexes;

    public SpreadSelector(List<Spread> spreads, String spreadSelection) {
        this.allSpreads = spreads;
        this.spreadSelection = spreadSelection;
        this.indexes = new ArrayList<int[]>();
        this.makeSelectIndex();
    }

    public void makeSelectIndex() {
        String[] strAry = this.spreadSelection.split(",");
        int i = 0;
        while (i < strAry.length) {
            int[] index;
            String[] strIndex = strAry[i].split("-");
            if (strIndex.length == 2) {
                index = new int[]{Integer.parseInt(strIndex[0].trim()), Integer.parseInt(strIndex[1].trim())};
                if (!this.wasAdded(index)) {
                    this.indexes.add(index);
                }
            } else {
                index = new int[]{Integer.parseInt(strIndex[0].trim())};
                if (!this.wasAdded(index)) {
                    this.indexes.add(index);
                }
            }
            ++i;
        }
    }

    public List<Spread> select() {
        ArrayList<Spread> spreads = new ArrayList<Spread>();
        int i = 0;
        while (i < this.indexes.size()) {
            SpreadFilter spreadFilter = new SpreadFilter(this.allSpreads);
            if (this.indexes.get(i).length == 2) {
                spreadFilter.filter(this.indexes.get(i)[0], this.indexes.get(i)[1]);
            } else {
                spreadFilter.filter(this.indexes.get(i)[0]);
            }
            int j = 0;
            while (j < spreadFilter.getFilterdSpreads().size()) {
                spreads.add(spreadFilter.getFilterdSpreads().get(j));
                ++j;
            }
            ++i;
        }
        return spreads;
    }

    public boolean wasAdded(int[] index) {
        int i = 0;
        if (i < this.indexes.size()) {
            if (this.indexes.get(i).length == 2) {
                if (index.length == 2) {
                    return index[1] >= this.indexes.get(i)[0] && this.indexes.get(i)[1] >= index[0];
                }
                return this.indexes.get(i)[0] <= index[0] && index[0] <= this.indexes.get(i)[1];
            }
            if (index.length == 2) {
                return index[0] <= this.indexes.get(i)[0] && this.indexes.get(i)[0] <= index[1];
            }
            return this.indexes.get(i)[0] == index[0];
        }
        return false;
    }
}

