/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class MoveTreeToolBar
extends JToolBar
implements ActionListener {
    protected JButton prev = new JButton(new ImageIcon("./icons/prev_page.png"));
    protected JButton next;
    protected int historycounter = 0;
    protected int pathCount = 0;
    private AbstractGSWindow parent;

    public MoveTreeToolBar(AbstractGSWindow parent) {
        this.prev.setEnabled(false);
        this.prev.addActionListener(this);
        this.prev.setActionCommand("prev");
        this.prev.setToolTipText("Previous page (Alt + UP)");
        this.prev.setMnemonic(38);
        this.add(this.prev);
        this.next = new JButton(new ImageIcon("./icons/next_page.png"));
        this.next.setEnabled(false);
        this.next.addActionListener(this);
        this.next.setActionCommand("next");
        this.next.setToolTipText("Next page (Alt + DOWN)");
        this.next.setMnemonic(40);
        this.add(this.next);
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Spread spread;
        int scale = this.parent.getSpreadCanvas().imageLabel.scale;
        ImageLabel.Show lineSegment = this.parent.getSpreadCanvas().imageLabel.getLineSegmentShowingMode();
        if (e.getActionCommand().equals("next")) {
            Spread spread2 = WorkspaceWindow.getInstance().getSpreadInTree(this.pathCount + 1);
            if (spread2 != null) {
                if (!(this.parent instanceof GSEditor)) {
                    WorkspaceWindow.getInstance().setSpread(spread2);
                    WorkspaceWindow.getInstance().setImageSearch(spread2.toString());
                    WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
                    WorkspaceWindow.getInstance().getHistoryToolBar().setHistoryCanvasScale(scale);
                    WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
                    WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
                } else {
                    ((GSEditor)this.parent).getSMLTabbedPane().setSpread(spread2);
                    ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setScale(scale);
                    ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
                    ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.showImage();
                    ((GSEditor)this.parent).updateMoveToolBar();
                }
            }
        } else if (e.getActionCommand().equals("prev") && (spread = WorkspaceWindow.getInstance().getSpreadInTree(this.pathCount - 1)) != null) {
            if (!(this.parent instanceof GSEditor)) {
                WorkspaceWindow.getInstance().setSpread(spread);
                WorkspaceWindow.getInstance().setImageSearch(spread.toString());
                WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setScale(scale);
                WorkspaceWindow.getInstance().getHistoryToolBar().setHistoryCanvasScale(scale);
                WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
                WorkspaceWindow.getInstance().getSpreadCanvas().imageLabel.showImage();
            } else {
                ((GSEditor)this.parent).getSMLTabbedPane().setSpread(spread);
                ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setScale(scale);
                ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.setLineSegmentShowingMode(lineSegment);
                ((GSEditor)this.parent).getSMLTabbedPane().getSpreadCanvas().imageLabel.showImage();
                ((GSEditor)this.parent).updateMoveToolBar();
            }
        }
    }

    public void setPathCount(int pathCount) {
        this.pathCount = pathCount;
        Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
        if (spread != null) {
            this.next.setEnabled(true);
        } else {
            this.next.setEnabled(false);
        }
        spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
        if (spread != null) {
            this.prev.setEnabled(true);
        } else {
            this.prev.setEnabled(false);
        }
    }
}

