/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.swingui;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import smart_gs.util.LinkCounter;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.MarkupInputDialog;

public class MarkupDialog {
    protected EditorTextPane textPane;
    protected int start;
    protected int end;
    protected int id;
    protected String tagname = null;
    protected int setLocation_x = 0;
    protected int setLocation_y = 0;

    public MarkupDialog(EditorTextPane textPane, int start, int end) {
        this.textPane = textPane;
        this.start = start;
        this.end = end;
    }

    public void show() {
        Object[] objects = this.makeTagList();
        MarkupInputDialog markupInputDialog = new MarkupInputDialog((Frame)new JFrame(), "Mark up", true, objects);
        markupInputDialog.setLocationRelativeTo(null);
        markupInputDialog.setResizable(false);
        markupInputDialog.setLocation(this.setLocation_x, this.setLocation_y);
        markupInputDialog.setVisible(true);
        String tagName = markupInputDialog.getSelectComboBox();
        if (tagName == null) {
            return;
        }
        this.id = LinkCounter.getID();
        this.tagname = tagName;
        this.textPane.createHyperlink(this.tagname, String.valueOf(this.id));
        Properties property = new Properties();
        property.put("id", "" + this.id);
        this.textPane.getGSHTMLEditorTextPane().updateText();
        this.textPane.setCaretPosition(this.start);
        this.textPane.getGSHTMLEditorTextPane().addTagList(tagName);
    }

    protected String getTagName() {
        return this.tagname;
    }

    protected Object[] makeTagList() {
        Vector<String> taglist = new Vector<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("tags.txt"));
            while ((line = reader.readLine()) != null) {
                taglist.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List tagnames = this.textPane.getGSHTMLEditorTextPane().getTagNames();
        if (tagnames != null) {
            int i = 0;
            while (i < tagnames.size()) {
                if (!taglist.contains(((String)tagnames.get(i)).trim())) {
                    taglist.add(((String)tagnames.get(i)).trim());
                }
                ++i;
            }
        }
        return taglist.toArray();
    }

    public void setLocation(int i, int j) {
        this.setLocation_x = i;
        this.setLocation_y = j;
    }
}

