/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.swingui.toolbar;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import smart_gs.swingui.toolbar.action.CurrentTextSearchActionListener;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.EditorToolBarPlan;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;
import sml_editor.swingui.toolbar.action.RedoAction;
import sml_editor.swingui.toolbar.action.RemoveTagAction;
import sml_editor.swingui.toolbar.action.UndoAction;

public class EditorToolBar
extends JToolBar {
    public static final int EDIT_MODE_BROWSE = 0;
    public static final int EDIT_MODE_SOURCE = 1;
    public static final int EDIT_MODE_EDIT = 2;
    public int edit_mode = 2;
    protected EditorTextPane textPane;
    protected CopyAction copyAction;
    protected CutAction cutAction;
    protected PasteAction pasteAction;
    protected MarkupAction markupAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected RemoveTagAction removeTagAction;
    protected CurrentTextSearchActionListener currentTextSearchAction;
    protected JButton copy;
    protected JButton cut;
    protected JButton paste;
    protected JButton markup;
    protected JButton removeTag;
    protected JButton undo;
    protected JButton redo;
    protected JButton search;
    protected JToggleButton source;
    protected JToggleButton browse;
    protected JToggleButton edit;
    protected EditorToolBarPlan toolBarPlan;

    public EditorToolBar(EditorTextPane textPane) {
        this(textPane, new EditorToolBarPlan());
    }

    public EditorToolBar(EditorTextPane textPane, EditorToolBarPlan toolBarPlan) {
        this.toolBarPlan = toolBarPlan;
        this.textPane = textPane;
        this.copyAction = new CopyAction();
        this.cutAction = new CutAction();
        this.pasteAction = new PasteAction();
        this.markupAction = new MarkupAction();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.removeTagAction = new RemoveTagAction();
        this.currentTextSearchAction = new CurrentTextSearchActionListener();
        this.copy = new JButton(new ImageIcon("./icons/copy.gif"));
        this.copy.addActionListener(this.copyAction);
        this.copy.setToolTipText("Copy");
        this.copy.setFocusable(false);
        if (toolBarPlan.isCopy()) {
            this.add(this.copy);
        }
        this.cut = new JButton(new ImageIcon("./icons/cut.gif"));
        this.cut.addActionListener(this.cutAction);
        this.cut.setToolTipText("Cut");
        this.cut.setFocusable(false);
        if (toolBarPlan.isCut()) {
            this.add(this.cut);
        }
        this.paste = new JButton("Paste");
        this.paste.addActionListener(this.pasteAction);
        this.paste.setToolTipText("Paste");
        this.paste.setFocusable(false);
        if (toolBarPlan.isPaste()) {
            this.add(this.paste);
        }
        this.markup = new JButton("Mark up");
        this.markup.addActionListener(this.markupAction);
        this.markup.setToolTipText("Mark up");
        this.markup.setFocusable(false);
        if (toolBarPlan.isMarkup()) {
            this.add(this.markup);
        }
        this.undo = new JButton(new ImageIcon("./icons/undo.gif"));
        this.undo.addActionListener(this.undoAction);
        this.undo.setToolTipText("Undo");
        if (toolBarPlan.isUndo()) {
            this.add(this.undo);
        }
        this.redo = new JButton(new ImageIcon("./icons/redo.gif"));
        this.redo.addActionListener(this.redoAction);
        this.redo.setToolTipText("Redo");
        if (toolBarPlan.isRedo()) {
            this.add(this.redo);
        }
        this.removeTag = new JButton("Remove tag");
        this.removeTag.addActionListener(this.removeTagAction);
        this.search = new JButton("Text Search");
        this.search.addActionListener(this.currentTextSearchAction);
        this.search.setToolTipText("Text Search");
        if (toolBarPlan.isSearch()) {
            this.add(this.search);
        }
        this.source = new JToggleButton("Source");
        this.browse = new JToggleButton("Browse");
        this.edit = new JToggleButton("Edit");
        this.check(this.textPane);
        this.copyAction.setEditorTextPane(this.textPane);
        this.cutAction.setEditorTextPane(this.textPane);
        this.pasteAction.setEditorTextPane(this.textPane);
        this.markupAction.setEditorTextPane(this.textPane);
        this.undoAction.setEditorTextPane(this.textPane);
        this.redoAction.setEditorTextPane(this.textPane);
        this.removeTagAction.setEditorTextPane(this.textPane);
    }

    public void setTextPane(EditorTextPane textPane) {
        this.textPane = textPane;
        this.check(this.textPane);
        this.copyAction.setEditorTextPane(this.textPane);
        this.cutAction.setEditorTextPane(this.textPane);
        this.pasteAction.setEditorTextPane(this.textPane);
        this.markupAction.setEditorTextPane(this.textPane);
        this.undoAction.setEditorTextPane(this.textPane);
        this.redoAction.setEditorTextPane(this.textPane);
        this.removeTagAction.setEditorTextPane(this.textPane);
    }

    public EditorTextPane getEditorTextPane() {
        return this.textPane;
    }

    public void check(EditorTextPane textPane) {
        if (textPane == null) {
            this.copy.setEnabled(false);
            this.cut.setEnabled(false);
            this.paste.setEnabled(false);
            this.markup.setEnabled(false);
            this.removeTag.setEnabled(false);
            this.undo.setEnabled(false);
            this.redo.setEnabled(false);
            this.source.setEnabled(false);
            this.browse.setEnabled(false);
            this.edit.setEnabled(false);
            this.search.setEnabled(false);
        } else {
            this.copy.setEnabled(true);
            this.cut.setEnabled(true);
            this.paste.setEnabled(true);
            this.markup.setEnabled(true);
            this.removeTag.setEnabled(true);
            this.undo.setEnabled(true);
            this.redo.setEnabled(true);
            this.search.setEnabled(true);
            this.source.setEnabled(true);
            this.browse.setEnabled(true);
            this.edit.setEnabled(true);
            if (!(this.source.isSelected() || this.browse.isSelected() || this.edit.isSelected())) {
                if (this.toolBarPlan.isEdit()) {
                    this.edit.setSelected(true);
                } else if (this.toolBarPlan.isBrowse()) {
                    this.browse.setSelected(true);
                } else if (this.toolBarPlan.isSource()) {
                    this.source.setSelected(true);
                }
            }
        }
    }
}

