/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import webdav.WebDavChooser;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavProcessor;
import webdav.WebDavSyncChooser;
import webdav.WebDavUploadLoadEvent;

public class WebDavListenerAction {
    public void open() {
        Preference preference = Preference.getInstance();
        WebDavDownLoadEvent oldWebDavDownLoadEvent = WorkspaceWindow.getInstance().getWebDavDownLoadEvent();
        String owner = preference.getUserName();
        if (owner == null) {
            owner = "";
        }
        if (owner.equals("")) {
            owner = "unknown user";
        }
        Stack<String> stack = null;
        String startpath = null;
        if (oldWebDavDownLoadEvent != null) {
            Stack<String> stack_ = oldWebDavDownLoadEvent.getStack();
            if (stack_ != null && stack_.size() != 0) {
                stack = new Stack<String>();
                int i = 0;
                while (i < stack_.size()) {
                    stack.add((String)stack_.get(i));
                    ++i;
                }
            }
            startpath = oldWebDavDownLoadEvent.getDownloadpath();
        }
        WebDavChooser webDavChooser = new WebDavChooser(WorkspaceWindow.getInstance(), 0, owner, stack, startpath);
        if (oldWebDavDownLoadEvent != null) {
            webDavChooser.setLockToken(oldWebDavDownLoadEvent.getLockToken());
        }
        webDavChooser.setLocationRelativeTo(null);
        if (webDavChooser.isError()) {
            return;
        }
        webDavChooser.setVisible(true);
        WebDavDownLoadEvent webDavDownLoadEvent = webDavChooser.getWebDavChooserEvent();
        if (webDavDownLoadEvent == null) {
            return;
        }
        if (webDavChooser.isCancel()) {
            return;
        }
        if (webDavChooser.isError()) {
            return;
        }
        String file = webDavDownLoadEvent.getDownload();
        WorkspaceWindow.getInstance().setWebDavDownLoadEvent(webDavDownLoadEvent);
        WorkspaceWindow.getInstance().restore(new File(file));
        if (oldWebDavDownLoadEvent != null && webDavDownLoadEvent.isUnlock()) {
            WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
            if (webDavProcessor == null) {
                JOptionPane.showMessageDialog(new JFrame(), "It failed in login to WebDAV.", "fatal", 0);
                return;
            }
            String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
            String unlockname = oldWebDavDownLoadEvent.getDownloaname();
            String locktoken = oldWebDavDownLoadEvent.getLockToken();
            try {
                webDavProcessor.unlock(unlockpath, unlockname, locktoken);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        WorkspaceWindow.getInstance().setLastsave(1);
        WorkspaceWindow.setUpdated(false);
    }

    public void save() {
        WorkspaceWindow window = WorkspaceWindow.getInstance();
        Preference preference = Preference.getInstance();
        String owner = preference.getUserName();
        if (owner == null) {
            owner = "";
        }
        if (owner.equals("")) {
            owner = "unknown user";
        }
        boolean updated = WorkspaceWindow.isUpdated();
        File file = new File("./temp/gs/temp.gsx");
        window.saveAll(file);
        Stack<String> stack = null;
        String startpath = null;
        WebDavDownLoadEvent oldWebDavDownLoadEvent = WorkspaceWindow.getInstance().getWebDavDownLoadEvent();
        if (oldWebDavDownLoadEvent != null) {
            Stack<String> stack_ = oldWebDavDownLoadEvent.getStack();
            if (stack_ != null && stack_.size() != 0) {
                stack = new Stack<String>();
                int i = 0;
                while (i < stack_.size()) {
                    stack.add((String)stack_.get(i));
                    ++i;
                }
            }
            startpath = oldWebDavDownLoadEvent.getDownloadpath();
        }
        WebDavChooser webDavChooser = new WebDavChooser(WorkspaceWindow.getInstance(), 1, owner, stack, startpath);
        if (oldWebDavDownLoadEvent != null) {
            webDavChooser.setLockToken(oldWebDavDownLoadEvent.getLockToken());
        }
        WebDavUploadLoadEvent webDavUploadLoadEvent = new WebDavUploadLoadEvent();
        webDavUploadLoadEvent.setUploadfile(file);
        File currentFile = window.getCurrentFile();
        String uploadname = "";
        if (window.getLastsave() == 0) {
            if (currentFile != null) {
                uploadname = currentFile.getName();
            }
        } else if (window.getLastsave() == 1) {
            uploadname = oldWebDavDownLoadEvent.getDownloaname();
        }
        webDavUploadLoadEvent.setUploadname(uploadname);
        if (oldWebDavDownLoadEvent != null) {
            webDavUploadLoadEvent.setReadonly(oldWebDavDownLoadEvent.isReadonly());
        }
        webDavChooser.setWebDavUploadLoadEvent(webDavUploadLoadEvent);
        webDavChooser.setLocationRelativeTo(null);
        if (webDavChooser.isError()) {
            return;
        }
        webDavChooser.setVisible(true);
        WebDavDownLoadEvent webDavDownLoadEvent = webDavChooser.getWebDavChooserEvent();
        if (webDavDownLoadEvent == null) {
            WorkspaceWindow.setUpdated(updated);
            return;
        }
        if (webDavChooser.isCancel()) {
            WorkspaceWindow.setUpdated(updated);
            return;
        }
        if (webDavChooser.isError()) {
            WorkspaceWindow.setUpdated(updated);
            return;
        }
        WorkspaceWindow.getInstance().setWebDavDownLoadEvent(webDavDownLoadEvent);
        if (oldWebDavDownLoadEvent != null && webDavDownLoadEvent.isUnlock()) {
            WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
            if (webDavProcessor == null) {
                JOptionPane.showMessageDialog(new JFrame(), "It failed in login to WebDAV.", "fatal", 0);
                return;
            }
            String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
            String unlockname = oldWebDavDownLoadEvent.getDownloaname();
            String locktoken = oldWebDavDownLoadEvent.getLockToken();
            try {
                webDavProcessor.unlock(unlockpath, unlockname, locktoken);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        WorkspaceWindow.getInstance().setLastsave(1);
        WorkspaceWindow.setUpdated(false);
    }

    public void sync() {
        Preference preference = Preference.getInstance();
        String owner = preference.getUserName();
        if (owner == null) {
            owner = "";
        }
        if (owner.equals("")) {
            owner = "unknown user";
        }
        ArrayList<String> checkOpenList = new ArrayList<String>();
        checkOpenList.add(preference.getDscFolderPathString());
        checkOpenList.add(preference.getImageFolderPathString());
        WebDavSyncChooser webDavChooser = new WebDavSyncChooser((Frame)WorkspaceWindow.getInstance(), owner, null, null);
        webDavChooser.setCheckOpenList(checkOpenList);
        webDavChooser.setLocationRelativeTo(null);
        if (webDavChooser.isError()) {
            return;
        }
        webDavChooser.setVisible(true);
    }
}

