/*
 * Decompiled with CFR 0.152.
 */
package webdav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import smart_gs.logical.Preference;
import webdav.PropFindInfo;
import webdav.WebDavProcessor;
import webdav.WebDavSyncData;
import webdav.table.PropFindModel;
import webdav.table.PropFindRenderer;
import webdav.table.PropFindSort;

public class WebDavSyncViewTableFactory {
    private final PropFindModel model = new PropFindModel();
    private final JTable table;
    protected WebDavProcessor webDavProcessor;
    protected Stack stack = new Stack();
    protected String owner = "user";
    protected String lockToken;
    protected JButton openButton;
    protected String openPath;
    protected ArrayList checkOpenList = new ArrayList();
    public static final int INITIALIZE = 0;
    public static final int DOWNLOAD_DONE = 100;
    public static final int UPLOAD_DONE = 200;
    protected int event = 0;

    public WebDavSyncViewTableFactory(PropFindInfo[] propFindInfos, Color backgroundColor, final JButton openButton) {
        this.openButton = openButton;
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, false, row, column);
            }
        });
        this.table.setIntercellSpacing(new Dimension());
        this.table.setShowGrid(false);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setMinWidth(0);
        col.setMaxWidth(0);
        col.setResizable(false);
        col = this.table.getColumnModel().getColumn(1);
        col.setCellRenderer(new PropFindRenderer(this.table));
        col.setPreferredWidth(100);
        col = this.table.getColumnModel().getColumn(2);
        col.setPreferredWidth(300);
        InputMap im = this.table.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke stab = KeyStroke.getKeyStroke(9, 1);
        KeyStroke senter = KeyStroke.getKeyStroke(10, 64);
        im.put(tab, im.get(enter));
        im.put(stab, im.get(senter));
        if (propFindInfos != null) {
            int i = 0;
            while (i < propFindInfos.length) {
                this.model.addPropFindList(propFindInfos[i]);
                ++i;
            }
        }
        final Color orgColor = this.table.getSelectionBackground();
        final Color tflColor = backgroundColor;
        this.table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                WebDavSyncViewTableFactory.this.table.setSelectionForeground(Color.WHITE);
                WebDavSyncViewTableFactory.this.table.setSelectionBackground(orgColor);
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebDavSyncViewTableFactory.this.table.setSelectionForeground(Color.BLACK);
                WebDavSyncViewTableFactory.this.table.setSelectionBackground(tflColor);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point pt = me.getPoint();
                int row = WebDavSyncViewTableFactory.this.table.rowAtPoint(pt);
                String name = (String)WebDavSyncViewTableFactory.this.model.getValueAt(row, 1);
                String size = (String)WebDavSyncViewTableFactory.this.model.getValueAt(row, 3);
                if (me.getClickCount() == 2) {
                    if (size.equals("")) {
                        WebDavSyncViewTableFactory.this.model.clear();
                        openButton.setEnabled(false);
                        try {
                            boolean upflg = false;
                            if (name.equals("..")) {
                                WebDavSyncViewTableFactory.this.stack.pop();
                                name = "";
                                upflg = true;
                            }
                            String path = WebDavSyncViewTableFactory.this.getPath((String)WebDavSyncViewTableFactory.this.stack.peek());
                            PropFindInfo[] propFindInfoChild = WebDavSyncViewTableFactory.this.webDavProcessor.getPropFindInfo(String.valueOf(path) + name, 1);
                            if (WebDavSyncViewTableFactory.this.stack.size() != 1 || !upflg) {
                                PropFindInfo propFindInfo = new PropFindInfo();
                                propFindInfo.setDisplayname("..");
                                propFindInfo.setDirectory(true);
                                WebDavSyncViewTableFactory.this.model.addPropFindList(propFindInfo);
                            }
                            if (propFindInfoChild != null) {
                                propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                                int i = 0;
                                while (i < propFindInfoChild.length) {
                                    WebDavSyncViewTableFactory.this.model.addPropFindList(propFindInfoChild[i]);
                                    ++i;
                                }
                            }
                            if (!upflg) {
                                WebDavSyncViewTableFactory.this.stack.push(String.valueOf(path) + name);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        String path = WebDavSyncViewTableFactory.this.getPath((String)WebDavSyncViewTableFactory.this.stack.peek());
                        if (!name.equals("..")) {
                            WebDavSyncViewTableFactory.this.cehckEnabled(path, name);
                        } else {
                            openButton.setEnabled(false);
                        }
                    }
                } else if (size.equals("")) {
                    String path = WebDavSyncViewTableFactory.this.getPath((String)WebDavSyncViewTableFactory.this.stack.peek());
                    if (!name.equals("..")) {
                        WebDavSyncViewTableFactory.this.cehckEnabled(path, name);
                    } else {
                        openButton.setEnabled(false);
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = WebDavSyncViewTableFactory.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                String name = (String)WebDavSyncViewTableFactory.this.model.getValueAt(row, 1);
                String size = (String)WebDavSyncViewTableFactory.this.model.getValueAt(row, 3);
                if (size.equals("")) {
                    String path = (String)WebDavSyncViewTableFactory.this.stack.peek();
                    WebDavSyncViewTableFactory.this.cehckEnabled(path, name);
                }
            }
        });
        this.stack.push("");
    }

    public void cehckEnabled(String path, String name) {
        try {
            PropFindInfo[] propFindInfoChild = this.webDavProcessor.getPropFindInfo(String.valueOf(path) + name, 1);
            if (propFindInfoChild != null) {
                propFindInfoChild = new PropFindSort().sort(propFindInfoChild);
                boolean open = true;
                int matchcount = 0;
                int i = 0;
                while (i < propFindInfoChild.length) {
                    String displayname = propFindInfoChild[i].getDisplayname();
                    boolean match = false;
                    int j = 0;
                    while (j < this.checkOpenList.size()) {
                        String checkpath = (String)this.checkOpenList.get(j);
                        File file = new File(checkpath);
                        String checkname = file.getName();
                        if (displayname.toLowerCase().equals(checkname)) {
                            match = true;
                        }
                        ++j;
                    }
                    if (match) {
                        ++matchcount;
                    }
                    ++i;
                }
                if (this.checkOpenList.size() != matchcount) {
                    open = false;
                }
                this.openPath = open ? String.valueOf(path) + name : null;
                this.openButton.setEnabled(open);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCheckOpenList(ArrayList checkOpenList) {
        this.checkOpenList = checkOpenList;
    }

    public void sync() {
        WebDavSyncData webDavSyncData = new WebDavSyncData();
        Preference preference = Preference.getInstance();
        int i = 0;
        while (i < this.checkOpenList.size()) {
            if (!webDavSyncData.init() && this.webDavProcessor == null) {
                JOptionPane.showMessageDialog(new JFrame(), "It failed in login to WebDAV", "fatal", 0);
                return;
            }
            String path = (String)this.checkOpenList.get(i);
            File file = new File(path);
            String root = file.getAbsolutePath();
            root = root.substring(0, root.lastIndexOf(file.getName()));
            webDavSyncData.local(path, root);
            webDavSyncData.webdav(this.openPath, file.getName());
            webDavSyncData.sync(new File(root));
            ++i;
        }
        webDavSyncData.syncstart();
    }

    public void setWebDavProcessor(WebDavProcessor webDavProcessor) {
        this.webDavProcessor = webDavProcessor;
    }

    public JTable getJTable() {
        return this.table;
    }

    public void setStack(Stack stack) {
        this.stack = stack;
    }

    public String getPath(String path_) {
        String path = path_;
        if (path == null) {
            path = "";
        }
        if (!path.equals("")) {
            if (!path.equals("/")) {
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
            } else {
                path = "";
            }
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
        }
        return path;
    }
}

