/* $Id: ExplanatoryPanel.java 326 2011-08-27 05:24:05Z shayashi $ */

package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;


/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")
public class ExplanatoryPanel extends JPanel {

    private ExplanatoryNoteDialog parent;
	private GSExplanatoryNote explanatoryNote;
	private JPanel toolbarPanel;
	
	private GSEditorTextPane textPane;
	//2007/10/23 kazuhiro kobayashi
	private String title;
	private String origTitle;
	private JTextField nameField;
	
	
	
	/**
	 * @param note
	 */
	public ExplanatoryPanel(ExplanatoryNoteDialog parent,GSExplanatoryNote note) {
		this.parent = parent;
		this.explanatoryNote = note;
		this.title = this.explanatoryNote.getName();
		this.setLayout(new BorderLayout());
		
		JPanel notePanel = new JPanel();
		notePanel.setLayout(new BorderLayout());
		
		JPanel textPanel = new JPanel();
		textPanel.setLayout(new BorderLayout());

		String source = null;
		String xml = explanatoryNote.getSource();;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.explanatoryNote,source);
		textPane.setMarkup(false);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		JScrollPane scrollPane = new JScrollPane(this.textPane);
		textPanel.add(scrollPane,BorderLayout.CENTER);
		notePanel.add(textPanel,BorderLayout.CENTER);
		notePanel.setBorder(new LineBorder(Color.BLACK));
		JPanel infoPanel = this.createInfoPanel();
		notePanel.add(infoPanel,BorderLayout.NORTH);
		
		this.toolbarPanel = new JPanel();
		this.toolbarPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		EditorToolBarPlan toolBarPlan = new EditorToolBarPlan();
		toolBarPlan.setMarkup(false);
		toolBarPlan.setSearch(false);
		this.toolbarPanel.add(new GSEditorToolBar(textPane,toolBarPlan));
		
		
		JPanel buttonPanel = new JPanel();
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new OKAction());
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new CancelAction());
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		
		this.add(this.toolbarPanel,BorderLayout.NORTH);
		this.add(notePanel,BorderLayout.CENTER);
		this.add(buttonPanel,BorderLayout.SOUTH);
	}

	private JPanel createInfoPanel(){
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));		
		nameField = new JTextField(20);
		nameField.setBorder(new TitledBorder("Title"));
		nameField.setText(this.title);
		this.origTitle = this.title;
		panel.add(nameField);
		return panel;
	}
	
	public GSEditorTextPane getTextPane() {
		return textPane;
	}
	public JPanel getTextPanel(){
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(this.textPane,BorderLayout.CENTER);
		return panel;
	}
	
	private class OKAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			String source = textPane.getSource("body");
			title = nameField.getText();
			if (!title.equals(origTitle)) {
				explanatoryNote.setName(title);
				WorkspaceWindow.setUpdated(true);
			}
			explanatoryNote.setSource("<xml><html>" + source + "</html></xml>");
			parent.dispose();
		}
	}
	
	private class CancelAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			parent.setIsCanceled(true);
			parent.dispose();
		}
	}

}
