package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.logical.Region;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.WorkspaceWindow;

public class BookmarkSizeAction implements ActionListener {

	BookmarkRegion bookmark;
	double size;
	
	public BookmarkSizeAction(Region region, double size) {
		this.bookmark = (BookmarkRegion)region;
		this.size = size;
	}
	@Override
	public void actionPerformed(ActionEvent arg0) {
		((BookmarkView)this.bookmark.getView()).changeSize(this.size);
		WorkspaceWindow.setUpdated(true);
	}

}
