/* $Id: EraserMode.java 317 2011-08-23 06:15:03Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.geom.Point2D;
import java.util.List;

import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.logical.Region;
public class EraserMode extends DrawingModeAdapter {

	private static Mode singleton = new EraserMode();

	public static Mode getInstance() {
		return singleton;
	}
	
	@Override
	public void mousePressed(GSMouseEvent e,SpreadCanvas canvas){
		Region region = canvas.getRegion(e.getPoint());
		new DeleteRegionAction(region).execute();
	}
}
