/* $Id: StandardTextDocument.java 204 2011-06-03 21:15:38Z minao $ */
package smart_gs.logical;

import smart_gs.logical.visitor.Visitor;


public class StandardTextDocument extends SmartDocument{
	
	public StandardTextDocument(String uri, String originalURI) {
		super();
		this.setURIs(uri, originalURI);
	}
	public StandardTextDocument() {
		super();
		this.setURIs();
	}
	public StandardTextDocument(String source,String name, String uri,String originalURI, String version){
		super(source);
		this.name = name;
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.STANDARD_TEXT_DOCUMENT;
	}
}
