/* $Id: ShortCutListPanel.java 373 2011-10-01 16:30:41Z shayashi $ */
package smart_gs.reasoning_web.desktop.swingui;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

@SuppressWarnings("serial")
public class ShortCutListPanel extends JPanel implements Observer, ListSelectionListener{
	
	private JList list;
	private DeskTopFolder folder;
	
	public ShortCutListPanel(DeskTopFolder folder){
		JLabel label = new JLabel("Elements");
		label.setBorder(new LineBorder(Color.BLACK));
		this.list = new JList();
		this.folder = folder;
		this.setLayout(new BorderLayout());
		
		this.add(label,BorderLayout.NORTH);
		List<DesktopElement> elements = this.folder.getAllElements();
		this.list.setListData(elements.toArray());
		
		this.list.addListSelectionListener(this);
		JScrollPane sp = new JScrollPane();
	    sp.getViewport().setView(list);
		this.add(sp,BorderLayout.CENTER);
	}

	public void reload(){
		this.list.removeAll();
		List<DesktopElement> elements = this.folder.getAllElements();
		this.list.setListData(elements.toArray());
		this.validate();
		this.repaint();
	}

	public void update() {
		this.reload();
	}
	//2007.06.11 Tsukushi Shimizu
	public void update(DeskTopFolder folder) {
		this.folder = folder;
		this.reload();
	}	

	public void valueChanged(ListSelectionEvent e) {
		DesktopElement element = (DesktopElement)this.list.getSelectedValue();
		if(element == null){
			return;
		}
		ReasoningWebFrame.getInstance().repaint();
	}

	public void setSelectedElement(DesktopElement selectedElement) {
		this.list.setSelectedValue(selectedElement,true);
	}

	public DesktopElement getSelectedElement() {
		return (DesktopElement) this.list.getSelectedValue();
	}
	
	public Object[] getSelectedElements() {
		return this.list.getSelectedValues();
	}
	
	
	
}
