/* $Id: LocalViewPanel.java 382 2011-10-06 13:00:55Z shayashi $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.Zombie;
import smart_gs.logical.region.RectangleRegion;
import smart_gs.menu.action.SpreadJumpAction;
import smart_gs.menu.action.SpreadOpenAction;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.action.ShowExplanatoryAction;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.util.InConstruction;
import smart_gs.util.ListenersRemover;
import smart_gs.util.Quadruple;

@SuppressWarnings("serial")
public class LocalViewPanel extends JPanel {

	// 2009/02/26 ADD NorthGrid
	private JTextField nameField;
	private static final int BOX_HEIGHT = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

	public LocalViewPanel(ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> elements,
			LocalViewFrame parent) {
		super();
		this.setLayout(new GridLayout(elements.size(), 1));

		Enumeration<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> enume = Collections.enumeration(elements);

		while (enume.hasMoreElements()) {
			Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer> quadruple = enume.nextElement();
			Connection connection = quadruple.getFirst();
			String connectionName = connection.getName();
			GS_RWElement element = quadruple.getSecond();
			GSExplanatoryNote expNote = quadruple.getThird();
			Integer peer_edge_type = quadruple.getFourth();

			JSplitPane rowForConnection = new JSplitPane();
	
			if (peer_edge_type == Connection.SOURCE) {
				rowForConnection.setBorder(new TitledBorder("Source: "
						+ element.getURI()));
			} else if (peer_edge_type == Connection.TARGET){
				rowForConnection.setBorder(new TitledBorder("Target: "
						+ element.getURI()));
			} else {
				rowForConnection.setBorder(new TitledBorder("Linked to itself: "
						+ element.getURI()));
			}

			int width = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;
			int height = GSConstants.ELEMENT_VIEW_PANEL_FOR_LOCAL_VIEW_SIZE;

			rowForConnection.setDividerLocation(width);
			
			try {
				JPanel elementViewPanel;
				if (element instanceof Region) {
					elementViewPanel = ((Region)element).createElementViewPanelForLocalView();
				} else if (element instanceof TextSegment) {
					elementViewPanel =((TextSegment)element).createElementViewPanelForLocalView();
				} else if (element instanceof Zombie) {
					elementViewPanel =((Zombie)element).createElementViewPanelForLocalView();
				} else {
					elementViewPanel = element.createElementViewPanel(width,height);
				}
				rowForConnection.setLeftComponent(elementViewPanel);
				
				
			} catch (NoWayToShowException e) {
				e.printStackTrace();
			}

			try {
				JPanel panel = new JPanel();
				panel.setLayout(new GridLayout(2,1));
				panel.setPreferredSize(new Dimension((int)(BOX_HEIGHT*1.5),BOX_HEIGHT));
				
				nameField = new JTextField(15);
				nameField.setBorder(new TitledBorder("Connection Name"));
				nameField.setText(connectionName);
				panel.add(nameField);		
				
				JButton editButton = new JButton("Explantory Note");
				panel.add(editButton);
				editButton.addActionListener(new ShowExplanatoryAction(expNote));
				rowForConnection.setRightComponent(panel);

			} catch (Exception e) {
				e.printStackTrace();
			}
			this.add(rowForConnection);
		}
	}
}
