/* $Id: SearchDialog.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import smart_gs.image_search.normal.swingui.ImageSearchPanel;
import smart_gs.logical.Region;
import smart_gs.text_search.swingui.TextSearchPanel;

public class SearchDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	JPanel panel1;
	JPanel panel2;
	
	public SearchDialog (Region region) {
		super(new JFrame(), "Search");
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);

		JTabbedPane searchTab = new JTabbedPane();

		if (region == null) {
			panel1 = new ImageSearchPanel();
		} else {
			panel1 = new ImageSearchPanel(region);
		}
		panel2 = new TextSearchPanel();
		
		searchTab.addTab("Image Search", panel1);
		searchTab.addTab("Global Search", panel2);
		
		mainPanel.add(searchTab);
		this.pack();
	}

}
