/* $Id: AddSpreadDirectoryAction.java 339 2011-09-07 03:01:03Z shayashi $ */
package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.JOptionPane;

import smart_gs.logical.Preference;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.filter.ImageDirectoryFilter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSStandardPath;

// 2011.04.10 shayashi
public class AddSpreadDirectoryAction implements ActionListener{
	SpreadTree tree;
	File imageFolder = new File(Preference.getInstance().getImageFolderPathString());
	File openDirectory;
	String imageFolderPath;
	String openDirectoryPath;
	SpreadDirectory openSpreadDirectory;
	DefaultMutableTreeNode currentNode;
	
	public AddSpreadDirectoryAction(File openDirectory, SpreadDirectory openSpreadDirectory){
		tree = SpreadTree.getInstance();
		imageFolderPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(imageFolder));
		this.openDirectory=openDirectory;
		this.openSpreadDirectory=openSpreadDirectory;
		openDirectoryPath= GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(openDirectory));
	}
	
	public void actionPerformed(ActionEvent e) {
		TreePath [] tmpTreePaths = tree.getSelectedPaths();
		currentNode = (DefaultMutableTreeNode)tmpTreePaths[0].getLastPathComponent();
		JFileChooser chooser = new JFileChooser(openDirectory);
		FileFilter filter = new ImageDirectoryFilter();
		chooser.setMultiSelectionEnabled(true);
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		chooser.setFileFilter(filter);		

		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
	
		File files[] = chooser.getSelectedFiles();
		int size = files.length;

		for (int count = 0; count <size; count++) {
			File file = files[count];
			if(file != null){
				String openDirPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(openDirectory));
				String dirToAddPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(file));

				if(!dirToAddPath.startsWith(imageFolderPath)){
					JOptionPane.showMessageDialog(new Frame(), 
							String.format("Directory %s \n is not in Image Folder %s.",dirToAddPath,imageFolderPath),"Information",JOptionPane.DEFAULT_OPTION);
					return;
				}
				String dirName = file.getName();
				String path = openDirPath + "/" + dirName;
				if(!path.equals(dirToAddPath)){
					JOptionPane.showMessageDialog(new Frame(), 
							String.format("Directory %s \n is not in the directory specified",dirName),"Information",JOptionPane.DEFAULT_OPTION);
					return;
				}
				tree.addDir(currentNode,openDirectory,dirName);
			}
		}
	}
	


}
