/* $Id: Pair.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

public class Pair<L,R> {

	  private final L left;
	  private final R right;

	  public Pair (L left1, R right1) {
	    this.left = left1;
	    this.right = right1;
	  }

	  public L getLeft() { return left; }
	  public R getRight() { return right; }

	  public int hashCode() { return left.hashCode() ^ right.hashCode(); }

	  public boolean equals(Object o) {
	    if (o == null) return false;
	    if (!(o instanceof Pair)) return false;
	    Pair pairo = (Pair) o;
	    return this.left.equals(pairo.getLeft()) &&
	           this.right.equals(pairo.getRight());
	  }

	}
