/* $Id: SmlDocument.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬F 2004/10/12
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package sml_editor.node;

import java.util.StringTokenizer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;


/**
 * @author kawamura
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class SmlDocument extends SmlChildNode {
	private Document fDocument;
	private SmlElement fRoot;
	
	/**
	 * @param document
	 */
	public SmlDocument(Document document) {
		fDocument = document;
		fRoot = new SmlElement(document.getDocumentElement());
	}

	protected int calculateLength() {
		return fRoot.calculateLength();
	}

	public Node getNode() {
		return fDocument;
	}

	public SmlElement createElement(String tagName) {
		Element elem = fDocument.createElement(tagName);
		return new SmlElement(elem);
	}
	
	public SmlText createTextNode(String data) {
		Text text = fDocument.createTextNode(data);
		return new SmlText(text);
	}
	
	public SmlBR createBRNode() {
		Element elem = fDocument.createElement("br");
		return new SmlBR(elem);
	}
	
	public SmlElement getDocumentElement() {
		return fRoot;
	}

	public short getNodeType() {
		return SmlNode.DOCUMENT_NODE;
	}

	/**
	 * pX킷SmlNode擾B
	 * Ⴆpath "/2/4/3" Ȃ΁A
	 * root2Ԗڂ̎q4Ԗڂ̎q3Ԗڂ̎qłm[hԂB
	 * @param path
	 * @return
	 */
	public SmlNode getNodeByPath(String path) {
		try {
			SmlNode node = fRoot;
			StringTokenizer tokens = new StringTokenizer(path, "/");
			while(tokens.hasMoreTokens()) {
				int index = Integer.parseInt(tokens.nextToken());
				node = ((SmlElement)node).getChild(index);
			}
			return node;
		} catch (NumberFormatException e) {
			// TODO  catch ubN
			e.printStackTrace();
		} catch (NullPointerException e) {
			// TODO  catch ubN
			e.printStackTrace();
		}
		return null;
	}
}
