/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs;

import java.awt.Rectangle;
import java.util.ArrayList;
import jp.ac.hokudai.meme.core_smart_gs.DSCFileHeader;
import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;

public class DSCData {
    protected double[][] dscData_ = null;
    protected ArrayList slitDataList_ = null;
    protected DSCFileHeader header_ = null;
    protected ArrayList cumslitinPage_ = null;
    protected ArrayList slitinPage_ = null;
    protected int[] lineNos_ = new int[0];
    protected int[] slitNos_ = new int[0];

    public DSCData() {
        this.slitDataList_ = new ArrayList();
        this.slitinPage_ = new ArrayList();
        this.cumslitinPage_ = new ArrayList();
    }

    public Rectangle[] getPageRectangle(int page) {
        return (Rectangle[])this.slitDataList_.get(page);
    }

    public int getSlitInPage(int page) {
        return (Integer)this.slitinPage_.get(page);
    }

    public int getCumSlitInPage(int page) {
        return (Integer)this.cumslitinPage_.get(page);
    }

    public void addDscData(DSCFileHeader addFileHeader, Rectangle[] slitData, double[][] addData) throws InvalidDataFormatException {
        if (this.validateHeader(addFileHeader)) {
            this.updateHeader(addFileHeader);
            this.slitDataList_.add(slitData);
            this.slitinPage_.add(new Integer(addFileHeader.getSlitCount()));
            if (this.cumslitinPage_ == null) {
                this.cumslitinPage_.add(new Integer(addFileHeader.getSlitCount()));
            } else {
                this.cumslitinPage_.add(new Integer(this.header_.getSlitCount()));
            }
            double[][] destDataArray = new double[this.header_.getSlitCount()][this.header_.getDscDimension()];
            if (this.dscData_ == null) {
                this.dscData_ = addData;
            } else {
                System.arraycopy(this.dscData_, 0, destDataArray, 0, this.dscData_.length);
                System.arraycopy(addData, 0, destDataArray, this.dscData_.length, addData.length);
                this.dscData_ = destDataArray;
            }
        } else {
            throw new InvalidDataFormatException("IllegalArgument: Input file format is different.");
        }
    }

    public void addDscData(DSCFileHeader addFileHeader, Rectangle[] slitData, double[][] addData, int[] lineNos, int[] slitNos) throws InvalidDataFormatException {
        this.addDscData(addFileHeader, slitData, addData);
        this.lineNos_ = this.concat(this.lineNos_, lineNos);
        this.slitNos_ = this.concat(this.slitNos_, slitNos);
    }

    public boolean hasDscData() {
        return this.dscData_ != null;
    }

    protected int[] concat(int[] src1, int[] src2) {
        int newSize = src1.length + src2.length;
        int[] dest = new int[newSize];
        System.arraycopy(src1, 0, dest, 0, src1.length);
        System.arraycopy(src2, 0, dest, src1.length, src2.length);
        return dest;
    }

    protected int pageIDToSerialID(int page, int pid) {
        int sid = page == 0 ? pid : (Integer)this.cumslitinPage_.get(page - 1) + pid;
        return sid;
    }

    protected void updateHeader(DSCFileHeader addFileHeader) {
        if (this.header_ == null) {
            this.header_ = addFileHeader;
        } else {
            this.header_.setSlitCount(this.header_.getSlitCount() + addFileHeader.getSlitCount());
        }
    }

    protected boolean validateHeader(DSCFileHeader header) {
        boolean valid = true;
        String mes = "";
        if (this.header_ == null) {
            return true;
        }
        if (this.header_.getVersion() != header.getVersion()) {
            valid = false;
            mes = mes + "IllegalArgument: Loading File Dimension.";
        }
        if (this.header_.getDscDimension() != header.getDscDimension()) {
            valid = false;
            mes = mes + "IllegalArgument: Loading File Version.";
        }
        if (this.header_.getFileType() != header.getFileType()) {
            valid = false;
            mes = mes + "IllegalArgument: Loading File Type.";
        }
        return valid;
    }

    public double[][] getDscData() {
        return this.dscData_;
    }

    public ArrayList getSlitDataList_() {
        return this.slitDataList_;
    }

    protected int[] serialIDToPageID(int sid) {
        int page = 0;
        while ((Integer)this.cumslitinPage_.get(page) <= sid) {
            ++page;
        }
        int pid = 0;
        pid = page == 0 ? sid : sid - (Integer)this.cumslitinPage_.get(page - 1);
        int lineNo = this.lineNos_[sid];
        int slitNo = this.slitNos_[sid];
        return new int[]{page, pid, lineNo, slitNo};
    }

    public PagedRect[] convertPieceIndexToRect(int[] indexes) {
        PagedRect[] prectary = new PagedRect[indexes.length];
        int indexlength = indexes.length;
        for (int i = 0; i < indexlength; ++i) {
            int[] ppos = this.serialIDToPageID(indexes[i]);
            int page = ppos[0];
            int pid = ppos[1];
            Rectangle rect = ((Rectangle[])this.slitDataList_.get(page))[pid];
            int lineNo = ppos[2];
            int slitNo = ppos[3];
            prectary[i] = new PagedRect(page, rect, lineNo, slitNo);
        }
        return prectary;
    }

    public static void main(String[] args) {
    }
}

