/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.test;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.ac.hokudai.meme.core_smart_gs.InvalidDataFormatException;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.QueryRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultRects;

public class SearchOperator {
    private final String[] imageExts_ = new String[]{"jpg", "png", "bmp"};
    private IDocumentSearcher searcher_ = DocumentSearcher.getInstance(2);
    private File[] fileList_ = null;
    private QueryRect query = null;
    private ResultRects result_ = null;

    public SearchOperator(int type) {
    }

    public File[] addDscFile(File[] dscFiles) throws IOException {
        File[] addFiles = this.chkFileList(dscFiles, this.fileList_);
        try {
            this.fileList_ = this.searcher_.addDscFile(addFiles);
        }
        catch (InvalidDataFormatException e) {
            System.out.println(e.getMessage());
            if (this.fileList_ == null) {
                this.fileList_ = new File[0];
            }
            return this.fileList_;
        }
        return this.fileList_;
    }

    private File[] chkFileList(File[] dscFiles, File[] fileList) {
        ArrayList<File> retList = new ArrayList<File>();
        if (fileList == null) {
            return dscFiles;
        }
        for (int i = 0; i < dscFiles.length; ++i) {
            File file = dscFiles[i];
            boolean rmFlag = false;
            for (int j = 0; j < fileList.length; ++j) {
                if (!file.equals(fileList[j])) continue;
                rmFlag = true;
            }
            if (rmFlag) continue;
            retList.add(file);
        }
        return retList.toArray(new File[0]);
    }

    public ResultRects search() {
        this.result_ = this.searcher_.search(this.query);
        return this.result_;
    }

    public boolean hasDscData() {
        return this.searcher_.hasDscData();
    }

    public void switchSeacher(int type) {
        this.searcher_.switchSeacher(type);
    }

    public String getImagePath(int pNum) {
        File targetDscFile = this.fileList_[pNum];
        File base = targetDscFile.getParentFile();
        String seedName = this.getBody(targetDscFile.getAbsolutePath());
        String ret = "";
        for (int i = 0; i < this.imageExts_.length; ++i) {
            File target = new File(base.getParent(), seedName + "." + this.imageExts_[i]);
            if (!target.exists()) continue;
            ret = target.getAbsolutePath();
        }
        return ret;
    }

    protected String getExtension(String filename) {
        int index = filename.lastIndexOf(".");
        if (index > -1) {
            return filename.substring(index + 1);
        }
        return "";
    }

    protected String getBody(String filename) {
        int index = filename.lastIndexOf(".");
        String result = index > -1 ? filename.substring(0, index) : new String(filename);
        index = result.lastIndexOf(File.separator);
        if (index > -1) {
            result = result.substring(index + 1);
        }
        return result;
    }

    public boolean setQuery(int downX, int downY, int upX, int upY, int pageIndex) {
        int tmp;
        if (downX < 0 || downY < 0 | upX < 0 | upY < 0) {
            return false;
        }
        if (downX > upX) {
            tmp = downX;
            downX = upX;
            upX = tmp;
        }
        if (downY > upY) {
            tmp = downY;
            downY = upY;
            upY = tmp;
        }
        Rectangle select = new Rectangle(downX, downY, upX - downX, upY - downY);
        PagedRect pRect = new PagedRect(pageIndex, select);
        this.query = new QueryRect();
        this.query.addQueryPRect(pRect);
        return true;
    }

    public PagedRect[] confirmQueryRect() {
        return this.searcher_.rectConfirm(this.query).getAllRects();
    }

    public int getPageCount() {
        return this.fileList_.length;
    }
}

