/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import smart_gs.logical.GSResource;
import smart_gs.logical.ResourceBasket;
import smart_gs.menu.action.ResourceListSelectionFrame;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;

public class AddToBasketAction
implements ActionListener {
    private ResourceBasket bucket;
    private GSResource resource;

    public AddToBasketAction(ResourceBasket bucket, GSResource resource) {
        this.bucket = bucket;
        this.resource = resource;
    }

    public AddToBasketAction(GSResource resource) {
        this.resource = resource;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.bucket != null) {
            this.bucket.addResource(this.resource);
            ResourceListSelectionFrame selectionFrame = ResourceBasketsFrame.getInstance().getSelectionFrame(this.bucket);
            if (selectionFrame != null) {
                ResourceBasketsFrame.getInstance().getSelectionFrame(this.bucket).update();
                if (selectionFrame.getSaveOption()) {
                    WorkspaceWindow.setUpdated(true);
                }
            } else {
                ResourceBasketsFrame.getInstance().createAndAddResourceListSelectionFrame(this.bucket);
            }
        } else {
            ResourceBasketsFrame.getInstance().setResource(this.resource);
            ResourceBasketsFrame.getInstance().showResourceBasketFrame();
        }
    }
}

