/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import smart_gs.drawing_tool.ExLine2D;

public abstract class View {
    public static final int RECTANGLE = 0;
    public static final int MARKER = 1;
    public static final int POLYGON = 2;
    public static final int LINE_SEGMENT = 3;
    public static final int LINE = 4;
    public static final int MEMOPAD = 5;
    public static final int BOOKMARK = 6;
    public static final int ANCHOR = 7;
    protected boolean isSelected;
    protected boolean isEmphasized;
    protected boolean isProtected;
    protected boolean isSelectable = true;
    protected Color defaultColor;
    protected Stroke defaultStroke;
    protected Color selectionColor = Color.RED;
    protected Stroke selectionStroke = new BasicStroke();
    protected Color emphasizeColor = Color.RED;
    protected Stroke emphasizeStroke = new BasicStroke(5.0f);
    protected Color protectedColor;
    protected Stroke protectedStroke;
    protected String title;

    protected View() {
        Color c;
        this.protectedColor = c = new Color(50, 150, 100);
        this.protectedStroke = new BasicStroke(2.0f);
        this.defaultColor = Color.black;
    }

    public abstract void moveBy(Point2D var1);

    public abstract boolean contains(Point2D var1);

    public abstract View enlargedView(double var1, double var3, double var5);

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setIsEmphasized(boolean isEmphasized) {
        this.isEmphasized = isEmphasized;
    }

    public void setIsProtected(String protection) {
        this.isProtected = protection.equals("protected");
    }

    public final void draw(Graphics2D g) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        if (this.isEmphasized) {
            g.setColor(this.emphasizeColor);
            g.setStroke(this.emphasizeStroke);
        } else if (this.isSelected) {
            g.setColor(this.selectionColor);
            g.setStroke(this.selectionStroke);
        } else if (this.isProtected) {
            g.setColor(this.protectedColor);
            g.setStroke(this.protectedStroke);
        } else {
            g.setColor(this.defaultColor);
            if (this.defaultStroke != null) {
                g.setStroke(this.defaultStroke);
            }
        }
        this.drawShape(g);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    protected abstract void drawShape(Graphics2D var1);

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Stroke getSelectionStroke() {
        return this.selectionStroke;
    }

    public Color getProtectedColor() {
        return this.protectedColor;
    }

    public Stroke getProtectedStroke() {
        return this.protectedStroke;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public void setSelectionStroke(Stroke stroke) {
        this.selectionStroke = stroke;
    }

    public void setProtectedColor(Color color) {
        this.protectedColor = color;
    }

    public void setProtectedStroke(Stroke stroke) {
        this.protectedStroke = stroke;
    }

    public abstract Rectangle2D getRectangle2D();

    public final Rectangle getRectangle() {
        Rectangle2D rect = this.getRectangle2D();
        int x = (int)rect.getX();
        int y = (int)rect.getY();
        int width = (int)rect.getWidth();
        int height = (int)rect.getHeight();
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    public abstract String getTypeString();

    public abstract int getType();

    public abstract void drawLinkedShape(Graphics2D var1, Image var2);

    public abstract void drawTemporaryShape(Graphics2D var1, Image var2);

    public abstract Element createXMLElement(Document var1);

    public boolean containsInCorner(Point2D point) {
        return false;
    }

    public boolean isResizable() {
        return false;
    }

    public void resize(Point2D d) {
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public abstract Point getCenterPoint();

    public void setViewColor(ViewColor color) {
    }

    public static boolean lineContains(ExLine2D line, double breadth, Point2D point) {
        double y2;
        double y1;
        double x1;
        if (line.getP1().getX() < line.getP2().getX()) {
            x1 = line.getP1().getX();
            y1 = line.getP1().getY();
            double x2 = line.getP2().getX();
            y2 = line.getP2().getY();
        } else {
            x1 = line.getP2().getX();
            y1 = line.getP2().getY();
            double x2 = line.getP1().getX();
            y2 = line.getP1().getY();
        }
        double d = line.getP1().distance(line.getP2());
        double y = y2 - y1;
        double theta = Math.asin(y / d);
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, x1, y1);
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1 - breadth / 2.0, d, breadth);
        Shape shape = rotate.createTransformedShape(rect);
        return shape.contains(point);
    }

    public abstract String getTypeStringForDisplay();

    public int getIndex() {
        return 0;
    }

    public String getTitle() {
        if (this.title == null || this.title.equals("")) {
            return "UNTITLED";
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public abstract void drawLinkIcon(Graphics2D var1, Image var2);

    public abstract void drawTemporaryIcon(Graphics2D var1);

    public static enum ViewColor {
        YELLOW,
        CYAN,
        MAGENTA,
        GREEN,
        TRANSPARENT,
        OPAQUE;

    }
}

