/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.research.swingui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.research.SearchResultSet;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.util.ImageCropper;

public class RESearchResultPanel
extends JPanel {
    protected List<SearchResultSet> results;
    protected List<JPanel> nextResults;
    protected List<JPanel> currentResults;
    private Thread nextThread = null;
    protected final int MARGIN_WIDTH = 100;
    protected final int SIZE_TO_DISPLAY = 20;
    protected Color grayColor;
    private List<JCheckBox> checkLists;
    private boolean isFirst = true;
    private int count = 0;

    public RESearchResultPanel(List<SearchResultSet> results) {
        this.results = results;
        this.nextResults = new ArrayList<JPanel>();
        this.currentResults = new ArrayList<JPanel>();
        this.checkLists = new ArrayList<JCheckBox>();
        Color color = Color.GRAY.brighter();
        this.setLayout(new GridLayout(20, 1));
        this.grayColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    public void showResult(int count) {
        this.removeAll();
        if (this.isFirst) {
            this.createResults(count);
            for (int i = 0; i < this.currentResults.size(); ++i) {
                this.add(this.currentResults.get(i));
            }
            this.isFirst = false;
            final int nextCount = count + 1;
            this.nextThread = new Thread(){

                @Override
                public void run() {
                    super.run();
                    RESearchResultPanel.this.createResults(nextCount);
                }
            };
            this.nextThread.start();
            return;
        }
        if (this.nextThread.isAlive()) {
            try {
                this.nextThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.nextResults.size(); ++i) {
            this.add(this.nextResults.get(i));
        }
        final int nextCount = count + 1;
        this.nextThread = new Thread(){

            @Override
            public void run() {
                super.run();
                RESearchResultPanel.this.createResults(nextCount);
            }
        };
        this.nextThread.start();
    }

    public void createResults(int count) {
        int beginIndex = count * 20;
        this.nextResults.clear();
        for (int i = beginIndex; i < beginIndex + 20 && i < this.results.size(); ++i) {
            JPanel labelPanel = new JPanel();
            JCheckBox checkBox = new JCheckBox();
            this.checkLists.add(checkBox);
            labelPanel.add(checkBox);
            SearchResultSet set = this.results.get(i);
            List<SearchResult> res = set.getResults();
            for (int j = 0; j < res.size(); ++j) {
                JPanel p = new JPanel(new FlowLayout(0));
                JLabel label = new JLabel();
                Spread spread = res.get(j).getSpread();
                Image image = spread.getImage();
                Rectangle rect = res.get(j).getRectangle();
                Image bufImage = new ImageCropper(image, (Rectangle2D)rect).crop();
                ImageIcon icon = new ImageIcon(bufImage);
                label.setIcon(icon);
                p.add(label);
                labelPanel.add(p);
                p.setBorder(new LineBorder(Color.black));
                spread.release();
            }
            labelPanel.setBorder(new TitledBorder(res.get(0).getSpread().getURI()));
            labelPanel.addMouseListener(new LabelMouseListener(set));
            if (this.nextThread == null) {
                this.currentResults.add(labelPanel);
                continue;
            }
            this.nextResults.add(labelPanel);
        }
    }

    public void next() {
        ++this.count;
        this.showResult(this.count);
    }

    public void back() {
        --this.count;
        this.showResult(this.count);
    }

    protected class LabelMouseListener
    extends MouseAdapter {
        private SearchResultSet set;

        public LabelMouseListener(SearchResultSet set) {
            this.set = set;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            new GSEditor(this.set.getResults()).setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RESearchResultPanel.this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RESearchResultPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

