/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import smart_gs.GSVersion;
import smart_gs.logical.URICreator;
import smart_gs.logical.URIObject;

public class OldGSFileConverter {
    private static final String HEADER = "smart://";
    private static final String SEP1 = "/";
    private static final String SEP2 = "^";
    private static final String SEP3 = "#";
    private static final String SEP4 = "@";
    private File file;
    private Document document;
    private HashMap<String, String> uriMap;

    public OldGSFileConverter(File file) {
        this.file = file;
        this.uriMap = new HashMap();
    }

    public Document getDocumentFromGSFile() {
        Document document = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(this.file);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    public File convertGSFile() {
        File gsxFile = new File(this.file.getAbsolutePath() + "_converted.gsx");
        this.document = this.getDocumentFromGSFile();
        this.convertDocument();
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.document);
            StringWriter output = new StringWriter();
            transformer.transform(source, new StreamResult(output));
            String string = output.toString();
            int p = string.indexOf("?>") + 2;
            String former = string.substring(0, p);
            String latter = string.substring(p + 1);
            String newstring = former + "\n<!DOCTYPE rootElement>" + latter;
            ZipOutputStream writer = new ZipOutputStream(new FileOutputStream(gsxFile));
            writer.putNextEntry(new ZipEntry("spread.xml"));
            writer.write(newstring.getBytes("UTF-8"));
            writer.close();
            transformer = null;
            source = null;
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        factory = null;
        return gsxFile;
    }

    private void convertDocument() {
        Element rootElement = this.document.getDocumentElement();
        Element spreadTree = (Element)rootElement.getElementsByTagName("spreadTree").item(0);
        this.convertSpreadTree(spreadTree);
        Element presentationTree = (Element)rootElement.getElementsByTagName("presentationTree").item(0);
        if (presentationTree == null) {
            presentationTree = (Element)rootElement.getElementsByTagName("noteTree").item(0);
        }
        this.convertPresentationTree(presentationTree);
        Element rwElement = (Element)rootElement.getElementsByTagName("reasoning_web").item(0);
        this.convertRWElements(rwElement);
    }

    private Element getExpNotes() {
        Element rwElement = (Element)this.document.getDocumentElement().getElementsByTagName("reasoning_web").item(0);
        return (Element)rwElement.getElementsByTagName("expNotes").item(0);
    }

    private void convertSpreadTree(Element element) {
        Element dir = (Element)element.getElementsByTagName("directory").item(0);
        this.convertSpreadDirectory(dir, "smart://directory/");
    }

    private void convertSpreadDirectory(Element element, String path) {
        int i;
        String name = URICreator.modifyName(element.getAttribute("name"));
        String oldURI = element.getAttribute("uri");
        String uri = path + name + SEP1 + URICreator.getURIExtension();
        this.setURIandVersion(element, oldURI, uri);
        NodeList directoryList = element.getElementsByTagName("directory");
        NodeList spreadList = element.getElementsByTagName("spread");
        for (i = 0; i < directoryList.getLength(); ++i) {
            this.convertSpreadDirectory((Element)directoryList.item(i), URIObject.chopLast(uri));
        }
        for (i = 0; i < spreadList.getLength(); ++i) {
            this.convertSpread((Element)spreadList.item(i), OldGSFileConverter.chopHeader(uri));
        }
    }

    private void convertSpread(Element element, String path) {
        String name = URICreator.modifyName(OldGSFileConverter.extractNameFromSpread(element.getAttribute("filename")));
        element.setAttribute("name", name);
        String oldURI = element.getAttribute("uri");
        String done = element.getAttribute("done");
        if (done.equals("true")) {
            return;
        }
        String uri = "smart://spread/" + name + SEP1 + URICreator.getURIExtension() + SEP2 + path;
        this.setURIandVersion(element, oldURI, uri);
        NodeList regionList = element.getElementsByTagName("region");
        for (int i = 0; i < regionList.getLength(); ++i) {
            this.convertRegion((Element)regionList.item(i), OldGSFileConverter.chopHeader(uri));
        }
        NodeList spreadDocumentList = element.getElementsByTagName("spreadDocument");
        for (int i = 0; i < spreadDocumentList.getLength(); ++i) {
            this.convertSpreadDocument((Element)spreadDocumentList.item(i), OldGSFileConverter.chopHeader(uri));
        }
        element.setAttribute("done", "true");
    }

    private static String extractNameFromSpread(String filename) {
        char sep = File.separatorChar;
        int beginIndex = filename.lastIndexOf(sep);
        int endIndex = filename.lastIndexOf(".");
        return filename.substring(beginIndex + 1, endIndex);
    }

    private void convertSpreadDocument(Element element, String path) {
        String oldURI = element.getAttribute("uri");
        String uri = "";
        String origSource = element.getAttribute("leftSource");
        String convertedSource = "";
        if (origSource.startsWith("<xml><left><html>") && origSource.endsWith("</html></left></xml>")) {
            origSource = origSource.substring("<xml><left><html>".length(), origSource.length() - "</html></left></xml>".length());
            convertedSource = "<xml><html>" + origSource + "</html></xml>";
        }
        element.setAttribute("source", convertedSource);
        element.removeAttribute("leftSource");
        element.removeAttribute("rightSource");
        int typeInt = Integer.parseInt(element.getAttribute("type"));
        String type = "";
        type = typeInt == 1 ? "firstIdat" : (typeInt == 2 ? "secondIdat" : "thirdIdat");
        uri = HEADER + type + SEP1 + URICreator.getURIExtension() + SEP2 + path;
        this.setURIandVersion(element, oldURI, uri);
        NodeList segmentList = element.getElementsByTagName("segment");
        for (int i = 0; i < segmentList.getLength(); ++i) {
            Element segment = (Element)segmentList.item(i);
            this.convertTextSegment(segment, OldGSFileConverter.chopHeader(uri));
        }
    }

    private void convertRegion(Element element, String path) {
        String oldURI = element.getAttribute("uri");
        Element view = (Element)element.getElementsByTagName("view").item(0);
        String type = view.getAttribute("type");
        if (type.equals("lasso")) {
            view.setAttribute("type", "polygon");
        }
        String uri = "smart://polygon/" + URICreator.getURIExtension() + SEP2 + path;
        this.setURIandVersion(element, oldURI, uri);
    }

    private void convertTextSegment(Element element, String path) {
        String oldURI = element.getAttribute("uri");
        String type = "segment";
        String uri = HEADER + type + SEP1 + URICreator.getURIExtension() + SEP2 + path;
        this.setURIandVersion(element, oldURI, uri);
    }

    private void convertPresentationTree(Element element) {
        Element usersNoteTree = this.document.createElement("usersNoteTree");
        Element directory = this.document.createElement("usersNoteDirectory");
        String directoryName = "root";
        String directoryURI = "smart://usersNoteDirectory/" + directoryName + SEP1 + URICreator.getURIExtension();
        directory.setAttribute("name", directoryName);
        directory.setAttribute("originalURI", directoryURI);
        directory.setAttribute("uri", directoryURI);
        directory.setAttribute("version", GSVersion.getVersion());
        NodeList list = element.getElementsByTagName("presentation");
        if (list.getLength() == 0) {
            list = element.getElementsByTagName("note");
        }
        String path = OldGSFileConverter.chopHeader(directoryURI);
        for (int i = 0; i < list.getLength(); ++i) {
            Element usersNote = this.getUsersNoteFromPresentation((Element)list.item(i), path);
            directory.appendChild(usersNote);
        }
        usersNoteTree.appendChild(directory);
        this.document.getDocumentElement().replaceChild(usersNoteTree, element);
    }

    private Element getUsersNoteFromPresentation(Element element, String path) {
        String oldURI = element.getAttribute("uri");
        Element usersNote = this.document.createElement("usersNote");
        usersNote.setAttribute("source", element.getAttribute("source"));
        usersNote.setAttribute("name", element.getAttribute("name"));
        usersNote.setAttribute("id", element.getAttribute("id") + "");
        String uri = "smart://usersNote/" + element.getAttribute("name") + SEP1 + URICreator.getURIExtension() + SEP2 + path;
        this.setURIandVersion(usersNote, oldURI, uri);
        NodeList list = element.getElementsByTagName("segment");
        for (int i = 0; i < list.getLength(); ++i) {
            Element segment = (Element)list.item(i);
            Element segmentClone = (Element)segment.cloneNode(true);
            this.convertTextSegment(segmentClone, OldGSFileConverter.chopHeader(uri));
            usersNote.appendChild(segmentClone);
        }
        return usersNote;
    }

    private void convertRWElements(Element element) {
        Element expNotes = (Element)element.getElementsByTagName("expNotes").item(0);
        this.convertExpNotes(expNotes);
        Element desktop = (Element)element.getElementsByTagName("desktop").item(0);
        this.convertDesktop(desktop);
        NodeList connectionList = element.getElementsByTagName("connection");
        for (int i = 0; i < connectionList.getLength(); ++i) {
            this.convertConnection((Element)connectionList.item(i));
        }
    }

    private void convertConnection(Element element) {
        String name = URICreator.modifyName(element.getAttribute("name"));
        NodeList pointerList = element.getElementsByTagName("pointer");
        Element sourcePointer = null;
        Element targetPointer = null;
        if (((Element)pointerList.item(0)).getAttribute("type").equals("source")) {
            sourcePointer = (Element)pointerList.item(0);
            targetPointer = (Element)pointerList.item(1);
        } else {
            sourcePointer = (Element)pointerList.item(1);
            targetPointer = (Element)pointerList.item(0);
        }
        String sourceOldURI = sourcePointer.getAttribute("uri");
        String targetOldURI = targetPointer.getAttribute("uri");
        String sourceURI = this.uriMap.get(sourceOldURI);
        String targetURI = this.uriMap.get(targetOldURI);
        sourcePointer.setAttribute("uri", sourceURI);
        targetPointer.setAttribute("uri", targetURI);
        String uri = "smart://connection/" + name + SEP1 + URICreator.getURIExtension() + SEP3 + sourceURI + SEP4 + targetURI;
        String oldURI = element.getAttribute("uri");
        this.setURIandVersion(element, oldURI, uri);
        Element expNote = (Element)element.getElementsByTagName("explanatory").item(0);
        this.convertExplanatoryNote(expNote);
        String id = expNote.getAttribute("id");
        NodeList notes = this.getExpNotes().getElementsByTagName("explanatory");
        for (int i = 0; i < notes.getLength(); ++i) {
            Element note = (Element)notes.item(i);
            if (!id.equals(note.getAttribute("id"))) continue;
            this.convertExplanatoryNote(note);
        }
    }

    private void convertDesktop(Element element) {
        NodeList folderList = element.getElementsByTagName("desktopFolder");
        for (int i = 0; i < folderList.getLength(); ++i) {
            this.convertFolder((Element)folderList.item(i), "smart://desktopFolder/");
        }
    }

    private void convertFolder(Element element, String path) {
        String name = URICreator.modifyName(element.getAttribute("name"));
        String uri = path + name + SEP1 + URICreator.getURIExtension();
        String oldURI = element.getAttribute("uri");
        this.setURIandVersion(element, oldURI, uri);
        NodeList folderList = element.getElementsByTagName("desktopFolder");
        for (int i = 0; i < folderList.getLength(); ++i) {
            this.convertFolder((Element)folderList.item(i), URIObject.chopLast(uri));
        }
        NodeList shortcutList = element.getElementsByTagName("shortcut");
        for (int i = 0; i < shortcutList.getLength(); ++i) {
            Element shortcut = (Element)shortcutList.item(i);
            if (shortcut.getAttribute("done").equals("true")) continue;
            this.convertShortcut(shortcut);
        }
    }

    private void convertShortcut(Element element) {
        String uri = "smart://shortcut/" + URICreator.getURIExtension();
        String oldURI = element.getAttribute("uri");
        this.setURIandVersion(element, oldURI, uri);
        Element bucket = (Element)element.getElementsByTagName("bucket").item(0);
        if (bucket == null) {
            bucket = (Element)element.getElementsByTagName("backet").item(0);
        }
        Element bucket2 = this.getBucketFromBacket(bucket);
        element.replaceChild(bucket2, bucket);
        NodeList queryList = element.getElementsByTagName("query");
        for (int i = 0; i < queryList.getLength(); ++i) {
            Element query = (Element)queryList.item(i);
            if (query.getAttribute("done").equals("true")) continue;
            this.convertQuery(query);
        }
        element.setAttribute("done", "true");
    }

    private Element getBucketFromBacket(Element element) {
        String oldURI = element.getAttribute("uri");
        Element bucket = this.document.createElement("bucket");
        bucket.setAttribute("source", element.getAttribute("source"));
        bucket.setAttribute("name", element.getAttribute("name"));
        String uri = "smart://bucket/" + URICreator.getURIExtension();
        this.setURIandVersion(bucket, oldURI, uri);
        return bucket;
    }

    private void convertQuery(Element element) {
        String oldSpreadURI;
        String spreadURI;
        String hasSpread = element.getAttribute("hasSpread");
        String done = element.getAttribute("done");
        if (done.equals("true")) {
            return;
        }
        String oldURI = element.getAttribute("uri");
        String ext = "";
        if (hasSpread.equals("true") && (spreadURI = this.uriMap.get(oldSpreadURI = element.getAttribute("spreadURI"))) != null) {
            element.setAttribute("spreadURI", spreadURI);
            ext = SEP2 + OldGSFileConverter.chopHeader(spreadURI);
        }
        String name = URIObject.modifyName(element.getAttribute("name"));
        String uri = "smart://query/" + name + SEP1 + URICreator.getURIExtension() + ext;
        this.setURIandVersion(element, oldURI, uri);
        element.setAttribute("done", "true");
    }

    private void convertExpNotes(Element element) {
    }

    private void convertExplanatoryNote(Element element) {
        String id = element.getAttribute("id");
        String name = URICreator.modifyName(element.getAttribute("name"));
        String oldURI = element.getAttribute("uri");
        String uri = "smart://explanatory/" + name + SEP1 + URICreator.getURIExtension();
        this.setURIandVersion(element, oldURI, id, uri);
        NodeList segmentList = element.getElementsByTagName("segment");
        for (int j = 0; j < segmentList.getLength(); ++j) {
            this.convertTextSegment((Element)segmentList.item(j), OldGSFileConverter.chopHeader(uri));
        }
    }

    private void setURIandVersion(Element element, String oldURI, String id, String uri) {
        element.setAttribute("uri", uri);
        element.setAttribute("originalURI", uri);
        element.setAttribute("oldVersionURI", oldURI);
        element.setAttribute("version", GSVersion.getVersion());
        this.uriMap.put(id, uri);
    }

    private static String chopHeader(String uri) {
        return uri.substring(HEADER.length());
    }

    private void setURIandVersion(Element element, String oldURI, String uri) {
        element.setAttribute("uri", uri);
        element.setAttribute("originalURI", uri);
        element.setAttribute("oldVersionURI", oldURI);
        element.setAttribute("version", GSVersion.getVersion());
        this.uriMap.put(oldURI, uri);
    }
}

