/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.desktop.swingui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.desktop.swingui.Observable;
import smart_gs.reasoning_web.desktop.swingui.RightClickPopupMenu;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.swingui.WorkspaceWindow;

public class FolderPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Observable {
    private DeskTopFolder folder;
    private DesktopElement selectedElement;
    private Point start;
    private Point end;

    public FolderPanel(DeskTopFolder folder) {
        this.folder = folder;
        this.folder.addObserver(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.notifyChange();
    }

    public DeskTopFolder getFolder() {
        return this.folder;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            DesktopElement element = this.getElement(e.getPoint());
            if (element == null) {
                return;
            }
            element.open();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private DesktopElement getElement(Point point) {
        List<DesktopElement> shortcuts = this.folder.getAllElements();
        for (int i = 0; i < shortcuts.size(); ++i) {
            if (!shortcuts.get(i).getView().contains(point)) continue;
            return shortcuts.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3 || e.getButton() == 1 & WorkspaceWindow.getInstance().isAlt()) {
            new RightClickPopupMenu(this.folder).show(this, e.getPoint().x, e.getPoint().y);
            this.repaint();
            return;
        }
        this.start = e.getPoint();
        List<DesktopElement> shortcuts = this.folder.getAllElements();
        for (int i = 0; i < shortcuts.size(); ++i) {
            if (!shortcuts.get(i).getView().contains(e.getPoint())) continue;
            this.selectedElement = shortcuts.get(i);
            ReasoningWebFrame.getInstance().getDesktopPanel().setSelectedElement(this.selectedElement);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.selectedElement != null) {
            DeskTopFolder container = null;
            if (this.selectedElement instanceof ShortCut) {
                container = this.folder.getFolder(e.getPoint());
            } else if (this.selectedElement instanceof DeskTopFolder) {
                container = this.folder.getFolderOtherThan(e.getPoint(), (DeskTopFolder)this.selectedElement);
            }
            if (container != null) {
                container.add(this.selectedElement);
                this.folder.remove(this.selectedElement);
            }
        }
        this.selectedElement = null;
        this.start = null;
        this.end = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedElement == null) {
            return;
        }
        this.end = e.getPoint();
        Point p = new Point(this.end.x - this.start.x, this.end.y - this.start.y);
        this.selectedElement.getView().moveBy(p);
        this.start = this.end;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void notifyChange() {
        this.removeAll();
        List<DesktopElement> shortcuts = this.folder.getAllElements();
        for (int i = 0; i < shortcuts.size(); ++i) {
            this.add((Component)shortcuts.get(i).getView().getLabel(), null);
        }
        this.repaint();
    }
}

