/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import smart_gs.logical.GSResource;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;

public class ExpNoteManager {
    private static ExpNoteManager singleton = new ExpNoteManager();
    private List<GSExplanatoryNote> notes = new ArrayList<GSExplanatoryNote>();

    private ExpNoteManager() {
    }

    public static ExpNoteManager getInstance() {
        return singleton;
    }

    public GSExplanatoryNote getExplanatoryNote(int id) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get(i).getId() != id) continue;
            return this.notes.get(i);
        }
        return null;
    }

    public void addNote(GSExplanatoryNote note) {
        this.notes.add(note);
    }

    public GSResource getResource(String uri) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get(i).equals(uri)) {
                return this.notes.get(i);
            }
            GSResource segment = this.notes.get(i).getTextSegmentByURI(uri);
            if (segment == null) continue;
            return segment;
        }
        return null;
    }

    public GSExplanatoryNote getExplanatoryNoteByTextSegmentURI(String uri) {
        String expNoteURI = this.extractExplanatoryNoteURIfromTextSegment(uri);
        for (int i = 0; i < this.notes.size(); ++i) {
            if (!URICreator.getURIWithoutHeader(this.notes.get(i)).equals(expNoteURI)) continue;
            System.out.println("  return notes.get(" + i + ")");
            return this.notes.get(i);
        }
        System.out.println("  return null");
        return null;
    }

    private String extractExplanatoryNoteURIfromTextSegment(String uri) {
        return uri.substring(uri.indexOf("^explanatory") + 1);
    }

    public List<GSExplanatoryNote> getNotes() {
        return this.notes;
    }

    public boolean has(GSExplanatoryNote note) {
        List<GSExplanatoryNote> notes = this.notes;
        for (GSExplanatoryNote n : notes) {
            if (n.getURI() != note.getURI()) continue;
            return true;
        }
        return false;
    }
}

