/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import smart_gs.reasoning_web.swingui.view.View;

public abstract class SquareView
extends View {
    protected Rectangle2D rect;
    protected final int MARKER_SIZE = 4;
    protected boolean toBeFilled = false;

    public SquareView() {
        this.currentColor = Color.white;
        this.defaultColor = Color.white;
    }

    @Override
    public void drawShape(Graphics2D g) {
        Color defaultColor = g.getColor();
        g.setColor(this.currentColor);
        g.fill(this.rect);
        if (this.isSelected) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.BLACK);
        }
        g.draw(this.rect);
        if (this.toBeFilled) {
            g.fill(this.rect);
        }
        g.setColor(defaultColor);
    }

    @Override
    public boolean contains(Point2D point) {
        return this.rect.contains(point);
    }

    @Override
    public void moveBy(Point2D d) {
        this.rect = new Rectangle2D.Double(this.rect.getX() + d.getX(), this.rect.getY() + d.getY(), this.rect.getWidth(), this.rect.getHeight());
    }

    public void fill() {
        this.toBeFilled = true;
    }

    public void unfill() {
        this.toBeFilled = false;
    }

    @Override
    public abstract String toString();

    public void select(Graphics2D g) {
        Rectangle2D bound = this.rect.getBounds2D();
        BasicStroke stroke = (BasicStroke)g.getStroke();
        float[] dashPhase = new float[]{2.0f, 2.0f};
        g.setStroke(new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), dashPhase, 0.0f));
        g.draw(bound);
        g.setStroke(stroke);
        this.setMarker(g, new Point2D.Double(bound.getMinX() - 4.0, bound.getMinY() - 4.0));
        this.setMarker(g, new Point2D.Double(bound.getMaxX(), bound.getMinY() - 4.0));
        this.setMarker(g, new Point2D.Double(bound.getMinX() - 4.0, bound.getMaxY()));
        this.setMarker(g, new Point2D.Double(bound.getMaxX(), bound.getMaxY()));
    }
}

