/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.LineSegEditorToolBar;

public class LineSegEditor
extends JFrame {
    private LineSegEditorCanvas lineSegEditorCanvas;
    private Spread spread;
    private LineSegEditorMode mode;
    private LineSegEditorToolBar toolBar;
    private Stack<List<LineSegmentForEdit>> linestack = new Stack();

    public void clearLinestack() {
        this.linestack = new Stack();
    }

    public boolean linestackIsEmpty() {
        return this.linestack.empty();
    }

    public List<LineSegmentForEdit> popLinestack() {
        if (!this.linestack.empty()) {
            return this.linestack.pop();
        }
        return null;
    }

    public List<LineSegmentForEdit> peekLinestack() {
        return this.linestack.peek();
    }

    public List<LineSegmentForEdit> getLinesForEdit() {
        return this.lineSegEditorCanvas.getLines();
    }

    public void pushLinestack(List<LineSegmentForEdit> lines) {
        this.linestack.push(new ArrayList<LineSegmentForEdit>(lines));
    }

    public void pushLinestack() {
        this.pushLinestack(this.getLinesForEdit());
    }

    public void setLinesForEdit(List<LineSegmentForEdit> lines) {
        this.getLineSegEditorCanvas().setLines(lines);
    }

    public void setSpread(Spread spread) {
        this.spread = spread;
    }

    public Spread getSpread() {
        return this.spread;
    }

    public LineSegEditor(Spread spread) {
        super("Line Segment Editor: " + spread.getName());
        this.lineSegEditorCanvas = new LineSegEditorCanvas(spread);
        this.spread = spread;
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel(new FlowLayout(0));
        this.toolBar = new LineSegEditorToolBar(this);
        panel1.add(this.toolBar);
        this.getContentPane().add((Component)panel1, "North");
        this.getContentPane().add((Component)this.lineSegEditorCanvas, "Center");
        this.setSize(900, 700);
        this.setVisible(true);
        this.repaint();
    }

    public void updateGUI() {
        this.validate();
        this.repaint();
    }

    public Frame getFrame() {
        return this;
    }

    public LineSegEditorCanvas getLineSegEditorCanvas() {
        return this.lineSegEditorCanvas;
    }

    public LineSegEditorToolBar getLineSegEditorToolBar() {
        return this.toolBar;
    }

    public void setMode(LineSegEditorMode mode) {
        this.mode = mode;
        this.getLineSegEditorCanvas().getLineSegEditorImageLabel().setMode(mode);
    }

    public LineSegEditorMode getMode() {
        return this.mode;
    }

    public void changeLinesSize(double mag) {
        double m = mag / 100.0;
        List<LineSegmentForEdit> lines = this.getLinesForEdit();
        for (int i = 0; i < lines.size(); ++i) {
            lines.get(i).changeSize(m);
        }
        WorkspaceWindow.getInstance().repaint();
    }

    public void slideLines(double x, double y) {
        List<LineSegmentForEdit> lines = this.getLinesForEdit();
        for (int i = 0; i < lines.size(); ++i) {
            lines.get(i).slideLine(x, y);
        }
        WorkspaceWindow.getInstance().repaint();
    }

    public void rewriteLineSegIndexes() {
        this.getLineSegEditorCanvas().rewriteLineSegIndexes();
    }
}

