/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.spread_selection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.spread_selection.GUIShowSpreadSelectionListsAction;
import smart_gs.spread_selection.ReadSpreadSelectionListAction;
import smart_gs.spread_selection.SaveSpreadSelectionListAction;
import smart_gs.spread_selection.ScopePanelAction;
import smart_gs.spread_selection.SpreadSelectionListGrammarChecker;
import smart_gs.spread_selection.SpreadSelector;

public class SetScopePanel
extends JPanel {
    private JRadioButton all;
    private JRadioButton currentDirectory;
    private JRadioButton selectSpread;
    private JRadioButton imageDictionary;
    private JPanel readSavePanel;
    private JButton readSelectedSpread;
    private JButton saveSelectedSpread;
    private JButton showSpreadSelectionLists;
    private JTextField pageSelectField;
    private static boolean allSelected = true;
    private static boolean currentDirectorySelected = false;
    private static boolean selectSpreadSelected = false;
    private static boolean imageDictionarySelected = false;
    private static String pageSelectFieldText = "";
    private ScopePanelAction scopePanelAction;
    private SetScopePanel mySetScopePanel;

    public SetScopePanel() {
        this(false);
    }

    public SetScopePanel(boolean imagemode) {
        if (!imagemode) {
            allSelected = true;
            imageDictionarySelected = false;
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Scope (Search Scope)"));
        this.all = new JRadioButton(imagemode ? "All Images" : "All Spreads");
        this.all.setSelected(allSelected);
        this.currentDirectory = new JRadioButton("Current Directory");
        this.currentDirectory.setSelected(currentDirectorySelected);
        this.selectSpread = new JRadioButton("Spread Selection List");
        this.selectSpread.setSelected(selectSpreadSelected);
        this.imageDictionary = new JRadioButton("Image Dictionary");
        this.imageDictionary.setSelected(imageDictionarySelected);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.all);
        group1.add(this.currentDirectory);
        group1.add(this.selectSpread);
        if (imagemode) {
            group1.add(this.imageDictionary);
        }
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridLayout(4, 1));
        leftPanel.add(this.all);
        leftPanel.add(this.currentDirectory);
        leftPanel.add(this.imageDictionary);
        if (imagemode) {
            this.imageDictionary.setEnabled(true);
        } else {
            this.imageDictionary.setEnabled(false);
        }
        leftPanel.add(this.selectSpread);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridLayout(4, 1));
        this.pageSelectField = new JTextField();
        this.pageSelectField.setFont(new Font("default", 0, 12));
        this.pageSelectField.setText(pageSelectFieldText);
        rightPanel.add(this.pageSelectField);
        rightPanel.add(new JLabel("e.g.:2,4,6-10"));
        this.readSelectedSpread = new JButton("Read");
        this.readSelectedSpread.addActionListener(new ReadSpreadSelectionListAction(this));
        this.saveSelectedSpread = new JButton("Save");
        this.saveSelectedSpread.addActionListener(new SaveSpreadSelectionListAction(this));
        this.showSpreadSelectionLists = new JButton("Show");
        this.showSpreadSelectionLists.addActionListener(new GUIShowSpreadSelectionListsAction(this.showSpreadSelectionLists, this.pageSelectField));
        this.readSavePanel = new JPanel();
        this.readSavePanel.add(this.readSelectedSpread);
        this.readSavePanel.add(this.saveSelectedSpread);
        this.readSavePanel.add(this.showSpreadSelectionLists);
        rightPanel.add(this.readSavePanel);
        this.mySetScopePanel = this;
        this.add((Component)leftPanel, "West");
        this.add((Component)rightPanel, "East");
        this.all.addActionListener(new ScopeSelectAction());
        this.selectSpread.addActionListener(new ScopeSelectAction());
        this.currentDirectory.addActionListener(new ScopeSelectAction());
        this.imageDictionary.addActionListener(new ScopeSelectAction());
        new ScopeSelectAction().actionPerformed(null);
    }

    public JTextField getPageSelectField() {
        return this.pageSelectField;
    }

    public List<Spread> getSpreadsToSearch() {
        if (this.all.isSelected()) {
            return SpreadTree.getInstance().getSpreads();
        }
        if (this.currentDirectory.isSelected()) {
            return SpreadTree.getInstance().getCurrentDirectory().getSpreads();
        }
        if (this.selectSpread.isSelected()) {
            String spreadSelection = this.pageSelectField.getText();
            if (!new SpreadSelectionListGrammarChecker().checks(spreadSelection)) {
                JOptionPane.showMessageDialog(this, spreadSelection + ": ill-formed selection list", "Error", 0);
                return null;
            }
            SpreadSelector selector = new SpreadSelector(SpreadTree.getInstance().getSpreads(), spreadSelection);
            return selector.select();
        }
        if (this.imageDictionary.isSelected()) {
            DictionaryXML dictionaryXML = DictionaryXML.getInstance();
            return dictionaryXML.getLoadSpreads();
        }
        return null;
    }

    public List<Spread> getDSCSpreads(List<Spread> spreads) {
        ArrayList<Spread> results = new ArrayList<Spread>();
        for (int i = 0; i < spreads.size(); ++i) {
            if (!spreads.get(i).hasDscFile()) continue;
            results.add(spreads.get(i));
        }
        return results;
    }

    public String getSelectedPage() {
        pageSelectFieldText = this.pageSelectField.getText();
        return this.pageSelectField.getText();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.all.setEnabled(flag);
        this.currentDirectory.setEnabled(flag);
        this.selectSpread.setEnabled(flag);
        this.pageSelectField.setEnabled(flag);
        this.imageDictionary.setEnabled(flag);
    }

    public boolean isAll() {
        return this.all.isSelected();
    }

    public boolean isCurrentDirectory() {
        return this.currentDirectory.isSelected();
    }

    public boolean isSelectSpread() {
        return this.selectSpread.isSelected();
    }

    public boolean isImageDictionary() {
        return this.imageDictionary.isSelected();
    }

    public String getPageSelectFieldString() {
        return this.pageSelectField.getText();
    }

    public void setScopePanelAction(ScopePanelAction scopePanelAction) {
        this.scopePanelAction = scopePanelAction;
    }

    public void execScopePanelAction() {
        if (this.scopePanelAction != null) {
            this.scopePanelAction.actionPerformed(this.mySetScopePanel);
        }
    }

    public class ScopeSelectAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (SetScopePanel.this.selectSpread.isSelected()) {
                SetScopePanel.this.pageSelectField.setEnabled(true);
                SetScopePanel.this.readSelectedSpread.setEnabled(true);
                SetScopePanel.this.saveSelectedSpread.setEnabled(true);
            } else if (SetScopePanel.this.all.isSelected() || SetScopePanel.this.currentDirectory.isSelected() || SetScopePanel.this.imageDictionary.isSelected()) {
                SetScopePanel.this.pageSelectField.setEnabled(false);
                SetScopePanel.this.readSelectedSpread.setEnabled(false);
                SetScopePanel.this.saveSelectedSpread.setEnabled(false);
            }
            allSelected = SetScopePanel.this.all.isSelected();
            currentDirectorySelected = SetScopePanel.this.currentDirectory.isSelected();
            selectSpreadSelected = SetScopePanel.this.selectSpread.isSelected();
            imageDictionarySelected = SetScopePanel.this.imageDictionary.isSelected();
            if (SetScopePanel.this.scopePanelAction != null) {
                SetScopePanel.this.scopePanelAction.actionPerformed(SetScopePanel.this.mySetScopePanel);
            }
        }
    }
}

