/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.GSResource;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteTree;
import smart_gs.smleditor.swingui.GSTreeTextEditor;
import smart_gs.swingui.UsersNoteTreeSelectPopupMenu;

public class UsersNoteTreePanel
extends JPanel
implements MouseListener {
    private UsersNoteTree tree;
    private JScrollPane scrollPane;

    public UsersNoteTreePanel() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.setAutoscrolls(true);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tree = UsersNoteTree.getInstance();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel tree_panel = new JPanel();
        tree_panel.setLayout(new FlowLayout(0));
        tree_panel.setBackground(Color.white);
        tree_panel.add(this.tree);
        tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.tree.addMouseListener(this);
        panel.add((Component)tree_panel, "Center");
        this.scrollPane.setViewportView(panel);
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getClickCount() == 2) {
                TreePath[] paths = this.tree.getSelectedPaths();
                if (paths == null || paths.length == 0) {
                    return;
                }
                GSResource selected = (GSResource)((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
                if (!(selected instanceof UsersNote)) {
                    return;
                }
                UsersNote selectedUsersNote = (UsersNote)selected;
                if (selectedUsersNote != null) {
                    GSTreeTextEditor editor = new GSTreeTextEditor(selectedUsersNote, selectedUsersNote.getName());
                    editor.setVisible(true);
                }
            } else if (e.getClickCount() == 1) {
                this.tree.getSelectionModel().setSelectionMode(4);
            }
            return;
        }
        if (e.getButton() == 3) {
            UsersNoteTreeSelectPopupMenu menu = new UsersNoteTreeSelectPopupMenu(this.tree);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public UsersNote getUsersNoteInTree(int row) {
        List<UsersNote> list = this.tree.getUsersNotes();
        try {
            for (int i = 0; i < list.size(); ++i) {
                UsersNote spread = list.get(i);
                if (spread.getPageViewIndex() != row) continue;
                return spread;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public UsersNoteTree getTree() {
        return this.tree;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

