/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import com.hexidec.ekit.GSHTMLEditorSearchActionListner;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.dictionary.DictionaryXML;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadSelectionListManager;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.UsersNoteTree;
import smart_gs.menu.export.ExportDialog;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSKeyEventPost;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.AutosaveAction;
import smart_gs.swingui.GSTabbedPaneManager;
import smart_gs.swingui.SpreadTreePanel;
import smart_gs.swingui.UsersNoteTreePanel;
import smart_gs.swingui.WorkspaceTabbedPane;
import smart_gs.swingui.WorkspaceWindowNorthPanel;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.action.GSFileFilter;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GsXMLSaver;
import smart_gs.util.LinkCounter;
import sml_editor.swingui.EditorTextPane;
import webdav.WebDavDownLoadEvent;
import webdav.WebDavListenerAction;
import webdav.WebDavProcessor;

public class WorkspaceWindow
extends AbstractGSWindow
implements GSEditorFrame,
Serializable {
    private static WorkspaceWindow singleton = new WorkspaceWindow();
    private JPanel imagePanel;
    private JTabbedPane leftPanel;
    private SpreadTreePanel spreadTreePanel;
    private UsersNoteTreePanel usersNoteTreePanel;
    private JPanel textDocumentPanel;
    private WorkspaceWindowNorthPanel workspaceWindowNorthPanel;
    private JLabel textDocumentStatusBar;
    private JLabel textDocumentStatusBar2;
    private JSplitPane mainSplitPane;
    private JSplitPane splitPane = null;
    private GSKeyEventPost gsKeyEventPost;
    private File currentFile;
    private static boolean updated = false;
    private static int lastsave = 0;
    private static int preferenceLoadStatus;
    private static boolean opened;
    private WebDavDownLoadEvent webDavDownLoadEvent;
    private Mode mode = new DefaultDrawingMode();
    private static boolean makeBackupFile;

    public static WorkspaceWindow getInstance() {
        return singleton;
    }

    public int getPreferenceLoadStatus() {
        return preferenceLoadStatus;
    }

    public WorkspaceWindow() {
        super("SMART-GS");
        preferenceLoadStatus = Preference.getInstance().load();
        if (preferenceLoadStatus != 0) {
            return;
        }
        String imageFolderPath = Preference.getInstance().getImageFolderPathString();
        File imageFolder = new File(imageFolderPath);
        if (!imageFolder.exists()) {
            imageFolder.mkdirs();
        }
        File tempDir = new File("./temp/gs/");
        tempDir.mkdirs();
        this.enableEvents(64L);
        this.imagePanel = new JPanel(new BorderLayout());
        this.spreadTreePanel = new SpreadTreePanel();
        this.usersNoteTreePanel = new UsersNoteTreePanel();
        this.leftPanel = new JTabbedPane();
        this.leftPanel.addTab("Images", this.spreadTreePanel);
        this.leftPanel.addTab("Notes", this.usersNoteTreePanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.workspaceWindowNorthPanel = new WorkspaceWindowNorthPanel(this);
        this.getContentPane().add((Component)this.workspaceWindowNorthPanel, "North");
        this.textDocumentPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new GSTabbedPane();
        this.displayWorksapceWindow(Preference.getWorkspaceWindowMode());
        if (!Preference.getInstance().getDefaultGsFilePathString().equals("")) {
            File defaultGsFile = new File(Preference.getInstance().getDefaultGsFilePathString());
            this.restore(defaultGsFile);
            this.autosave(defaultGsFile);
        } else {
            DictionaryXML.getInstance().init();
        }
        KeyboardFocusManager m = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.gsKeyEventPost = new GSKeyEventPost();
        m.addKeyEventPostProcessor(this.gsKeyEventPost);
    }

    public void displayWorksapceWindow(int workspaceWindowMode) {
        switch (workspaceWindowMode) {
            case 0: {
                this.mainSplitPane = new JSplitPane(0, this.imagePanel, this.textDocumentPanel);
                this.mainSplitPane.setDividerLocation(350);
                this.mainSplitPane.setOneTouchExpandable(true);
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1100, 800);
                break;
            }
            case 1: {
                this.mainSplitPane = new JSplitPane(0, this.textDocumentPanel, this.imagePanel);
                this.mainSplitPane.setDividerLocation(350);
                this.mainSplitPane.setOneTouchExpandable(true);
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1100, 800);
                break;
            }
            case 2: {
                this.mainSplitPane = new JSplitPane(1, this.imagePanel, this.textDocumentPanel);
                this.mainSplitPane.setDividerLocation(600);
                this.mainSplitPane.setOneTouchExpandable(true);
                this.mainSplitPane.getRightComponent().setMinimumSize(new Dimension(0, 0));
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1400, 700);
                break;
            }
            case 3: {
                this.mainSplitPane = new JSplitPane(1, this.textDocumentPanel, this.imagePanel);
                this.mainSplitPane.setDividerLocation(600);
                this.mainSplitPane.setOneTouchExpandable(true);
                this.mainSplitPane.getLeftComponent().setMinimumSize(new Dimension(0, 0));
                if (this.splitPane != null) {
                    this.getContentPane().remove(this.splitPane);
                }
                this.splitPane = new JSplitPane(1, this.leftPanel, this.mainSplitPane);
                this.splitPane.setOneTouchExpandable(true);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.setSize(1400, 700);
                break;
            }
            default: {
                this.mainSplitPane = new JSplitPane(1, this.imagePanel, this.textDocumentPanel);
            }
        }
        this.validate();
        this.repaint();
    }

    public void save() {
        this.tabbedPane.save();
    }

    @Override
    public void setSpread(Spread spread) {
        this.setSpread(spread, true);
        Spread currentSpread = this.getSpread();
        String spreadNameExt = "";
        if (currentSpread != null) {
            spreadNameExt = "   " + currentSpread.getName();
        }
        if (this.currentFile != null) {
            this.setTitle(this.currentFile.getName() + " - SMART-GS" + spreadNameExt);
        } else {
            this.setTitle("SMART-GS" + spreadNameExt);
        }
    }

    public void setSpread(Spread spread, boolean history) {
        if (this.tabbedPane != null) {
            this.tabbedPane.clear();
        }
        this.tabbedPane = new WorkspaceTabbedPane(this, spread);
        this.save();
        this.updateGUI(spread);
        if (history) {
            HistoryToolBar historyToolBar = this.workspaceWindowNorthPanel.getHistoryToolBar();
            int scale = this.getSpreadCanvas().imageLabel.scale;
            historyToolBar.addHistory(spread, scale);
        }
        this.updateMoveToolBar();
        Spread currentSpread = this.getSpread();
        String spreadNameExt = "";
        if (currentSpread != null) {
            spreadNameExt = "   " + currentSpread.getName();
        }
        if (this.currentFile != null) {
            this.setTitle(this.currentFile.getName() + " - SMART-GS" + spreadNameExt);
        } else {
            this.setTitle("SMART-GS" + spreadNameExt);
        }
    }

    public void updateMoveToolBar() {
        MoveTreeToolBar moveTreeToolBar = this.workspaceWindowNorthPanel.getMoveTreeToolBar();
        if (this.tabbedPane.getSpread() != null) {
            moveTreeToolBar.setPathCount(this.tabbedPane.getSpread().getPageViewIndex());
        }
    }

    public void setImageSearch(String q) {
        this.spreadTreePanel.search(q);
    }

    public Spread getSpreadInTree(int row) {
        return this.spreadTreePanel.getSpreadInTree(row);
    }

    @Override
    public void close() {
        super.close();
        SpreadTree.getInstance().clear();
        UsersNoteTree.getInstance().clear();
        GS_RWRepository.getInstance().clear();
        SpreadSelectionListManager.getInstance().clearSpreadSlectionLists();
        DictionaryXML.getInstance().init();
        this.spreadTreePanel.repaint();
        this.setTitle("SMART-GS");
        this.tabbedPane.removeAll();
        this.tabbedPane.repaint();
        this.validate();
    }

    @Override
    public void updateGUI(Spread spread) {
        this.textDocumentPanel.removeAll();
        Component imagePanel = ((WorkspaceTabbedPane)this.tabbedPane).getImagePanel();
        this.imagePanel.removeAll();
        this.imagePanel.add(imagePanel);
        this.textDocumentPanel.add(this.tabbedPane);
        this.textDocumentStatusBar = new JLabel("");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.textDocumentStatusBar, "First");
        this.textDocumentPanel.add((Component)jPanel, "South");
        this.validate();
    }

    @Override
    public GSTabbedPane createTabbedPane(Spread spread) {
        return new WorkspaceTabbedPane(this, spread);
    }

    @Override
    public SpreadCanvas getSpreadCanvas() {
        if (this.tabbedPane == null) {
            return null;
        }
        return ((WorkspaceTabbedPane)this.tabbedPane).getSpreadCanvas();
    }

    @Override
    public void setEditorToolBar(JToolBar toolbar) {
    }

    @Override
    public void setEditorTextPane(EditorTextPane textPane) {
        textPane.setSearchAction(new GSHTMLEditorSearchActionListner(){

            @Override
            public void actionPerformed() {
                SearchDialogManager.setGSEditorToolBar(WorkspaceWindow.getInstance().getGSEditorToolBar());
                SearchDialogManager.visible();
            }
        });
        this.tabbedPane.setEditorTextPane(textPane);
    }

    public GSEditorToolBar getGSEditorToolBar() {
        return this.tabbedPane.getGSEditorToolBar();
    }

    @Override
    public Spread getSpread() {
        return this.tabbedPane.getSpread();
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    public void restore(File file) {
        this.currentFile = file;
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, file.getName() + " does not exist\n");
            return;
        }
        try {
            Document document;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            if (file.getName().endsWith(".gsx")) {
                ZipFile gsxFile = new ZipFile(file);
                ZipEntry gsxSpread = gsxFile.getEntry("spread.xml");
                if (gsxSpread == null) {
                    JOptionPane.showMessageDialog(this, file.getName() + ": Invalid gsx file.");
                    return;
                }
                document = builder.parse(gsxFile.getInputStream(gsxSpread));
                gsxFile.close();
            } else {
                document = builder.parse(file);
            }
            Element rootElement = document.getDocumentElement();
            String counterValue = rootElement.getAttribute("counter");
            if (counterValue != null) {
                try {
                    LinkCounter.setID(Integer.parseInt(counterValue));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.setTitle(this.currentFile.getName() + " - SMART-GS");
            ReasoningWebFrame.getInstance().initializeContentsAndFrame();
            Element spreadElement = (Element)rootElement.getElementsByTagName("spreadTree").item(0);
            SpreadTree.getInstance().restore(spreadElement);
            Element usersNoteElement = (Element)rootElement.getElementsByTagName("usersNoteTree").item(0);
            UsersNoteTree.getInstance().clear();
            UsersNoteTree.getInstance().restore(usersNoteElement);
            Element rwElement = (Element)rootElement.getElementsByTagName("reasoning_web").item(0);
            GS_RWRepository.getInstance().clear();
            GS_RWRepository.getInstance().restore(rwElement);
            Element sslists = (Element)rootElement.getElementsByTagName("spreadSelectionLists").item(0);
            if (sslists != null) {
                SpreadSelectionListManager.getInstance().restore(sslists);
            }
            if (GS_RWRepository.getInstance().getBackgroundFilePath() != null && GS_RWRepository.getInstance().getBackgroundFilePath().length() > 0) {
                GlobalViewPanel.getInstance().setBackground(new File(GS_RWRepository.getInstance().getBackgroundFilePath()));
            }
            WorkspaceWindow.setUpdated(false);
            DictionaryXML.getInstance().load(file);
            DictionaryXML.getInstance().write();
            DictionaryXML.getInstance().setWarning(false);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.tabbedPane.clear();
        this.tabbedPane.validate();
        this.tabbedPane.repaint();
        this.validate();
    }

    public boolean saveAll() {
        return this.saveAll(null);
    }

    public boolean saveAll(File file) {
        this.tabbedPane.save();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = document.createElement("rootElement");
            rootElement.setAttribute("counter", String.valueOf(LinkCounter.intValue()));
            document.appendChild(rootElement);
            SpreadTree.getInstance().save(document, rootElement);
            UsersNoteTree.getInstance().save(document, rootElement);
            GS_RWRepository.getInstance().save(document, rootElement);
            SpreadSelectionListManager.getInstance().save(document, rootElement);
            if (file == null) {
                file = this.currentFile;
                String currentDirectory = Preference.getInstance().getGsFolderPathString();
                File directory = new File(currentDirectory);
                JFileChooser chooser = new JFileChooser(directory);
                if (this.currentFile != null) {
                    chooser.setSelectedFile(this.currentFile);
                }
                File file000 = chooser.getCurrentDirectory();
                chooser.setFileFilter(new GSFileFilter());
                String selectedFileName = "";
                while (!selectedFileName.endsWith(".gsx")) {
                    int input = chooser.showSaveDialog(WorkspaceWindow.getInstance());
                    if (input == 1) {
                        return false;
                    }
                    file = chooser.getSelectedFile();
                    selectedFileName = file.getName();
                    if (selectedFileName.endsWith(".gsx")) continue;
                    JOptionPane.showMessageDialog(null, "File name must ends with .gsx");
                    chooser.setSelectedFile(new File(selectedFileName + ".gsx"));
                }
            }
            String path = CanonicalPathString.get(file);
            new GsXMLSaver(document, path).save();
            WorkspaceWindow.setUpdated(false);
            return true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void autosave(File file) {
        int autoSaveInterval = 10;
        Timer timer = new Timer(60000 * autoSaveInterval, new AutosaveAction(file));
        timer.start();
    }

    public void exit() {
        int input;
        boolean notcofirm = false;
        if (WorkspaceWindow.isUpdated()) {
            String filename = null;
            if (lastsave == 0) {
                if (this.currentFile != null) {
                    filename = this.currentFile.getName();
                }
            } else {
                WebDavDownLoadEvent webDavDownLoadEvent = this.getWebDavDownLoadEvent();
                if (webDavDownLoadEvent != null) {
                    filename = webDavDownLoadEvent.getDownloaname();
                }
            }
            if ((input = JOptionPane.showConfirmDialog(this, filename == null ? "Save the edited contents?" : "\"" + filename + "\"   Save this file?")) == 0) {
                if (this.getLastsave() == 0) {
                    if (!this.saveAll()) {
                        return;
                    }
                } else {
                    WebDavListenerAction webDavListenerAction = new WebDavListenerAction();
                    webDavListenerAction.save();
                }
            } else if (input != 1 && input == 2) {
                return;
            }
            notcofirm = true;
        }
        if (!notcofirm && (input = JOptionPane.showConfirmDialog(this, "Exit SMART-GS?")) != 0) {
            return;
        }
        Preference.getInstance().save();
        this.tabbedPane.save();
        this.unlock();
        System.exit(0);
    }

    public void unlock() {
        WebDavDownLoadEvent oldWebDavDownLoadEvent = this.getWebDavDownLoadEvent();
        if (oldWebDavDownLoadEvent != null) {
            String unlockpath = oldWebDavDownLoadEvent.getDownloadpath();
            String unlockname = oldWebDavDownLoadEvent.getDownloaname();
            String locktoken = oldWebDavDownLoadEvent.getLockToken();
            WebDavProcessor webDavProcessor = WebDavProcessor.getInstance();
            if (webDavProcessor == null) {
                JOptionPane.showMessageDialog(new JFrame(), "It failed in login WebDav.", "fatal", 0);
                return;
            }
            try {
                webDavProcessor.unlock(unlockpath, unlockname, locktoken);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        File tempDir = new File("./temp/gs/");
        tempDir.delete();
        this.setWebDavDownLoadEvent(null);
    }

    public void export() {
        if (this.tabbedPane.isAvailable()) {
            this.tabbedPane.save();
        }
        String currentFileName = this.currentFile.getName();
        int index = currentFileName.lastIndexOf(46);
        ExportDialog frame = new ExportDialog(currentFileName.substring(0, index));
        frame.setVisible(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tabbedPaneSave() {
        GSTabbedPane gSTabbedPane = this.tabbedPane;
        synchronized (gSTabbedPane) {
            this.tabbedPane.save();
        }
    }

    public boolean isAlt() {
        return this.gsKeyEventPost.isAlt();
    }

    public boolean isCtrl() {
        return this.gsKeyEventPost.isCtrl();
    }

    public boolean isShift() {
        return this.gsKeyEventPost.isShift();
    }

    public boolean onlyOneOfAltCtrlShiftIsPressed() {
        return this.isAlt() ^ this.isCtrl() ^ this.isShift();
    }

    public void setStatusBarSource(String statusmessage) {
        if (!this.isTabbedPaneAvailable()) {
            JOptionPane.showMessageDialog(null, "Source: " + statusmessage);
            this.textDocumentStatusBar = new JLabel();
        }
        this.textDocumentStatusBar.setForeground(Color.RED);
        this.textDocumentStatusBar.setText("Source: " + statusmessage);
    }

    public void setStatusBarTarget(String statusmessage) {
        if (!this.isTabbedPaneAvailable()) {
            JOptionPane.showMessageDialog(null, "Target: " + statusmessage);
            this.textDocumentStatusBar = new JLabel();
        }
        this.textDocumentStatusBar.setForeground(Color.RED);
        this.textDocumentStatusBar.setText("Target: " + statusmessage);
    }

    public void setStatusBar2(String statusmessage) {
        this.textDocumentStatusBar2.setText(statusmessage);
    }

    public void resetStatusBar() {
        this.textDocumentStatusBar.setText("");
    }

    public boolean isTabbedPaneAvailable() {
        return this.tabbedPane.isAvailable();
    }

    @Override
    public GSTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public void processEvent(AWTEvent e) {
        super.processEvent(e);
        if (e.getID() == 205) {
            SearchDialogManager.setGSEditorToolBar(this.getGSEditorToolBar());
            if (this.tabbedPane != null) {
                String key = this.tabbedPane.getURI();
                if (key == null) {
                    return;
                }
                GSTabbedPane newTabbedPane = GSTabbedPaneManager.getGSTabbedPane(key);
                if (newTabbedPane != null) {
                    String windowid = GSTabbedPaneManager.getWindowsID(key);
                    if (windowid == null) {
                        return;
                    }
                    if (windowid.equals(key)) {
                        return;
                    }
                    newTabbedPane.save();
                    String fstidatSource = newTabbedPane.getFirstIDATSource();
                    this.tabbedPane.updateFirstIDAT(fstidatSource);
                    String secondSource = newTabbedPane.getSecondIDATSource();
                    this.tabbedPane.updateSecondIDAT(secondSource);
                    String thirdidatSource = newTabbedPane.getThirdIDATSource();
                    this.tabbedPane.updateThirdIDAT(thirdidatSource);
                    this.tabbedPane.updateText();
                    this.tabbedPane.save();
                    GSTabbedPaneManager.removeGSTabbedPane(key);
                }
            }
            if (this.mode != null) {
                DefaultState.getInstance().setMode(this.mode);
            }
        } else if (e.getID() == 206) {
            if (this.tabbedPane != null) {
                this.tabbedPane.save();
                String key = this.tabbedPane.getURI();
                GSTabbedPaneManager.setGSTabbedPane(key, key, this.tabbedPane);
            }
        } else if (e.getID() == 202 && this.tabbedPane != null) {
            String key = this.tabbedPane.getURI();
            if (key == null) {
                return;
            }
            GSTabbedPaneManager.close(key);
        }
    }

    public static boolean isFileOpened() {
        return opened;
    }

    public void setFileOpened(boolean opened) {
        WorkspaceWindow.opened = opened;
        makeBackupFile = true;
    }

    public static boolean isUpdated() {
        return updated;
    }

    public static void setUpdated(boolean updated) {
        WorkspaceWindow.updated = updated;
        if (WorkspaceWindow.isFileOpened()) {
            WorkspaceWindow.getInstance().backup();
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File file) {
        this.currentFile = file;
    }

    public WebDavDownLoadEvent getWebDavDownLoadEvent() {
        return this.webDavDownLoadEvent;
    }

    public void setWebDavDownLoadEvent(WebDavDownLoadEvent webDavDownLoadEvent) {
        this.webDavDownLoadEvent = webDavDownLoadEvent;
    }

    public int getLastsave() {
        return lastsave;
    }

    public void setLastsave(int lastsave) {
        WorkspaceWindow.lastsave = lastsave;
        if (lastsave == 1) {
            this.currentFile = null;
        }
    }

    public void backup() {
        if (this.currentFile == null) {
            return;
        }
        try {
            if (makeBackupFile) {
                String backupFileName = this.currentFile.getPath() + ".bak";
                FileUtils.copyFile(this.currentFile, new File(backupFileName));
                System.out.println(backupFileName);
                makeBackupFile = false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ImageToolBar getImageToolBar() {
        return this.workspaceWindowNorthPanel.getImageToolBar();
    }

    public HistoryToolBar getHistoryToolBar() {
        return this.workspaceWindowNorthPanel.getHistoryToolBar();
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void updateGUI() {
        Spread spread = this.getSpread();
        if (spread != null) {
            this.updateGUI(spread);
        }
    }

    static {
        opened = false;
        makeBackupFile = true;
    }
}

