package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import smart_gs.drawing_tool.DrawableCanvas;
import smart_gs.drawing_tool.LineSegEditorCanvas;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.LineSegment;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSTabbedPaneManager;
import smart_gs.swingui.ToolBarPanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.LineSegEditorToolBar;


@SuppressWarnings("serial")
public class LineSegEditor extends JFrame {
	
	private LineSegEditorCanvas lineSegEditorCanvas;
	private Spread spread;
	private LineSegEditorMode mode;
	private LineSegEditorToolBar toolBar;
	private Stack<List<LineSegmentForEdit>> linestack = new Stack();
		

	public void clearLinestack() {
		linestack = new Stack();
	}
	
	public boolean linestackIsEmpty() {
		return linestack.empty();
	}
	
	public List<LineSegmentForEdit> popLinestack() {
		if (! linestack.empty()) 
			return linestack.pop();
		else 
			return null;
	}
	
	public List<LineSegmentForEdit> peekLinestack() {
		return linestack.peek();
	}
	
	public List<LineSegmentForEdit> getLinesForEdit() {
		return lineSegEditorCanvas.getLines();
	}

	public void pushLinestack(List<LineSegmentForEdit> lines) {
		this.linestack.push(new ArrayList<LineSegmentForEdit>(lines));
	}

	public void pushLinestack() {
		pushLinestack(this.getLinesForEdit());
	}

	public void setLinesForEdit(List<LineSegmentForEdit> lines) {
		this.getLineSegEditorCanvas().setLines(lines);
	}

	public void setSpread(Spread spread){
		this.spread = spread;
	}
	
	public Spread getSpread() {
		return this.spread;
	}

	public LineSegEditor(Spread spread)  {
		super("Line Segment Editor: " + spread.getName());
		this.lineSegEditorCanvas = new LineSegEditorCanvas(spread);

		this.spread = spread;
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout());
		
		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		toolBar = new LineSegEditorToolBar(this);
		panel1.add(toolBar);
		this.getContentPane().add(panel1,BorderLayout.NORTH);
		this.getContentPane().add(lineSegEditorCanvas,BorderLayout.CENTER);

		
		this.setSize(900,700);
		this.setVisible(true);
		this.repaint();
	}

	public void updateGUI() {
		validate();
		repaint();
	}

	public Frame getFrame() {
		return this;
	}

	public LineSegEditorCanvas getLineSegEditorCanvas() {
		return lineSegEditorCanvas;
	}
	
	public 	LineSegEditorToolBar getLineSegEditorToolBar(){
		return  this.toolBar;
	}
	
	public void setMode(LineSegEditorMode mode) {
		this.mode = mode;
		getLineSegEditorCanvas().getLineSegEditorImageLabel().setMode(mode);
	}
	
	public LineSegEditorMode getMode() {
		return this.mode;
	}
	
	//20110220 shimizu add
	public void changeLinesSize(double mag){
		double m = mag/100;
		List<LineSegmentForEdit> lines = this.getLinesForEdit();
		for(int i=0;i<lines.size();i++){
			lines.get(i).changeSize(m);	
		}
		WorkspaceWindow.getInstance().repaint();
	}
	
	//20110303 shimizu add
	public void slideLines(double x, double y){
		List<LineSegmentForEdit> lines = this.getLinesForEdit();
		for(int i=0;i<lines.size();i++){
			lines.get(i).slideLine(x, y);
		}
		WorkspaceWindow.getInstance().repaint();
	}

	public void rewriteLineSegIndexes() {
		this.getLineSegEditorCanvas().rewriteLineSegIndexes();
		
	}
}
