/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.jersey.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class ErrorResponseFormatter {
    private static Properties messages;

    public static void setMessages(Properties props) {
        messages = props;
    }

    public static Errors formatError(Object key, Object ... args) {
        Errors errors = new Errors();
        errors.add(ErrorResponseFormatter.format(key, args));
        return errors;
    }

    public static Errors format(List<List<Object>> values) {
        Errors errors = new Errors();
        if (messages != null) {
            for (List<Object> keyArgs : values) {
                int length = keyArgs.size();
                Errors.Detail detail = null;
                if (length > 1) {
                    detail = ErrorResponseFormatter.format(keyArgs.get(0), keyArgs.subList(1, length).toArray());
                } else if (length == 1) {
                    detail = ErrorResponseFormatter.format(keyArgs.get(0), new Object[0]);
                }
                if (detail == null) continue;
                errors.add(detail);
            }
        }
        return errors;
    }

    private static Errors.Detail format(Object key, Object ... args) {
        Errors.Detail detail = new Errors.Detail();
        detail.key = ErrorResponseFormatter.formatMessageKey(key);
        String format = messages.getProperty(detail.key);
        if (format != null) {
            boolean packFound = false;
            Object[] newArgs = args;
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof Pack) {
                    Pack pack = (Pack)args[i];
                    if (!packFound) {
                        newArgs = new Object[args.length];
                        int j = 0;
                        while (j < i) {
                            newArgs[j] = args[j];
                            ++j;
                        }
                        packFound = true;
                    }
                    newArgs[i] = messages.containsKey(pack.value) ? messages.get(pack.value) : pack.value;
                } else if (packFound) {
                    newArgs[i] = args[i];
                }
                ++i;
            }
            detail.message = String.format(format, newArgs);
            return detail;
        }
        return detail;
    }

    private static String formatMessageKey(Object keyObj) {
        String keyString = keyObj.toString();
        int length = keyString.length();
        StringBuffer buf = new StringBuffer(keyString);
        int i = 0;
        while (i < length) {
            char c = keyString.charAt(i);
            if (!Character.isLowerCase(c)) {
                if (Character.isUpperCase(c)) {
                    buf.setCharAt(i, Character.toLowerCase(c));
                } else if (Character.isDigit(c)) {
                    buf.setCharAt(i, c);
                } else {
                    buf.setCharAt(i, '.');
                }
            }
            ++i;
        }
        return buf.toString();
    }

    @XmlRootElement(name="hcp")
    public static class Errors {
        @XmlAttribute
        public final String version = "1.0";
        @XmlElement(name="error")
        public List<Detail> details = new ArrayList<Detail>();

        public void add(Detail detail) {
            this.details.add(detail);
        }

        @XmlRootElement(name="error")
        public static class Detail {
            public String key;
            public String message;

            public boolean hasMessage() {
                return this.message != null;
            }

            public String toString() {
                if (this.message != null) {
                    return this.message;
                }
                return this.key;
            }
        }
    }

    public static class Pack {
        String value;

        public Pack(String value) {
            this.value = value;
        }
    }
}

