/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.validation.StringOf;
import jp.ac.nii.hcp.shared.validation.Validate;

@XmlRootElement(name="project")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Validate
public class HCPProject
implements Cloneable {
    public static final int NAME_MAX_LENGTH = 128;
    public static final String NAME_REGEX = "[^/\\\\\\s]+";
    public int sequence = 0;
    @StringOf(min=1, max=128, regex="[^/\\\\\\s]+")
    public String name;
    @XmlAttribute
    public int revision;
    public Accessibility accessibility;
    public String group;
    public Date created;
    public Date modified;
    @XmlElementWrapper(name="materials")
    @XmlElement(name="material")
    public List<HCPMaterial> materials;
    @XmlElementWrapper(name="documents")
    @XmlElement(name="document")
    public List<HCPDocument> documents;
    @XmlElementWrapper(name="attachments")
    @XmlElement(name="attachment")
    public List<HCPAttachment> attachments;

    public HCPProject() {
        this.name = null;
        this.revision = 0;
        this.accessibility = Accessibility.PRIVATE;
        this.created = null;
        this.modified = null;
        this.materials = new ArrayList<HCPMaterial>();
        this.documents = new ArrayList<HCPDocument>();
        this.attachments = new ArrayList<HCPAttachment>();
    }

    public HCPProject(String name, int revision, Accessibility accessibility, String group, Date created, Date modified) {
        this.name = name;
        this.revision = revision;
        this.accessibility = accessibility;
        this.group = group;
        this.created = created;
        this.modified = modified;
        this.materials = new ArrayList<HCPMaterial>();
        this.documents = new ArrayList<HCPDocument>();
        this.attachments = new ArrayList<HCPAttachment>();
    }

    public HCPProject clone() {
        HCPProject project = new HCPProject(this.name, this.revision, this.accessibility, this.group, this.created != null ? (Date)this.created.clone() : null, this.modified != null ? (Date)this.modified.clone() : null);
        for (HCPMaterial material : this.materials) {
            project.materials.add(material.clone());
        }
        for (HCPDocument document : this.documents) {
            project.documents.add(document.clone());
        }
        for (HCPAttachment attachment : this.attachments) {
            project.attachments.add(attachment.clone());
        }
        return project;
    }

    public static boolean validateName(String name) {
        return name != null && name.matches(NAME_REGEX) && name.length() > 0 && name.length() <= 128;
    }

    public boolean validate() {
        return HCPProject.validateName(this.name);
    }

    @XmlEnum
    public static enum Accessibility {
        PUBLIC,
        PRIVATE;

    }

    public static enum GroupPermission {
        WRITEABLE,
        READ_ONLY;

    }

    public static enum GroupRelation {
        OWNER,
        MEMBER;

    }
}

