/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.model;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.validation.StringOf;

@XmlRootElement
public abstract class HCPProjectContent
implements Cloneable {
    public static final int ID_MAX_LENGTH = 256;
    public int sequence = 0;
    @StringOf(min=1, max=256)
    public String id;
    public String description;
    public ContentType type;
    public Record record;

    public HCPProjectContent() {
        this.id = null;
        this.description = null;
        this.type = null;
        this.record = new Record();
    }

    public HCPProjectContent(String id, String description, ContentType type) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.record = null;
    }

    public static boolean validateId(String id) {
        return id != null && id.length() > 0 && id.length() < 256;
    }

    public boolean validate() {
        return HCPProjectContent.validateId(this.id);
    }

    public static enum ContentType {
        MATERIAL,
        DOCUMENT,
        ATTACHMENT;

    }

    public static class Record
    implements Cloneable {
        public int revision;
        public int added;
        public int deleted;
        public Date created;
        @XmlElement(name="created-by")
        public HCPUser createdBy;
        public Date modified;
        @XmlElement(name="modified-by")
        public HCPUser modifiedBy;

        public Record() {
            this.revision = 0;
            this.added = 0;
            this.deleted = 0;
            this.created = null;
            this.createdBy = null;
            this.modified = null;
            this.modifiedBy = null;
        }

        public Record(int revision, int added, int deleted, Date created, HCPUser createdBy, Date modified, HCPUser modifiedBy) {
            this.revision = revision;
            this.added = added;
            this.deleted = deleted;
            this.created = created;
            this.createdBy = createdBy;
            this.modified = modified;
            this.modifiedBy = modifiedBy;
        }

        public Record clone() {
            return new Record(this.revision, this.added, this.deleted, this.created != null ? (Date)this.created.clone() : null, this.createdBy != null ? this.createdBy.clone() : null, this.modified != null ? (Date)this.modified.clone() : null, this.modifiedBy != null ? this.modifiedBy.clone() : null);
        }
    }
}

