/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.module;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.module.BaseProcessor;
import jp.ac.nii.hcp.shared.module.ListAttributes;

public class UserProcessor
extends BaseProcessor {
    public UserProcessor(Connection db) {
        super(db);
    }

    public HCPUser authenticate(String email, String password) throws SQLException {
        String sql = "SELECT * FROM user WHERE email = ? AND password = PASSWORD(?) AND disabled = 0";
        ResultSet rs = this.doQuery(sql, email, password);
        if (rs.next()) {
            return new HCPUser(rs.getInt("sequence"), rs.getString("id"), rs.getString("email"), rs.getString("last_name"), rs.getString("first_name"), rs.getString("organization"), rs.getString("post"));
        }
        return null;
    }

    public boolean feedUser(HCPUser user) throws SQLException {
        ResultSet rs = null;
        if (user.sequence > 0) {
            rs = this.doQuery("SELECT * FROM user WHERE sequence = ?", user.sequence);
        } else if (user.id != null && user.id.length() > 0) {
            rs = this.doQuery("SELECT * FROM user WHERE id = ?", user.id);
        }
        if (rs == null || !rs.next()) {
            return false;
        }
        user.sequence = rs.getInt("sequence");
        user.id = rs.getString("id");
        user.email = rs.getString("email");
        user.lastName = rs.getString("last_name");
        user.firstName = rs.getString("first_name");
        user.organization = rs.getString("organization");
        user.post = rs.getString("post");
        user.disabled = rs.getInt("disabled") > 0;
        return true;
    }

    public boolean feedUserGroup(HCPUserGroup group) throws SQLException {
        ResultSet rs = null;
        if (group.sequence > 0) {
            rs = this.doQuery("SELECT * FROM user_group WHERE sequence = ?", group.sequence);
        } else if (group.id != null && group.id.length() > 0) {
            rs = this.doQuery("SELECT * FROM user_group WHERE id = ?", group.id);
        }
        if (rs == null || !rs.next()) {
            return false;
        }
        group.sequence = rs.getInt("sequence");
        group.id = rs.getString("id");
        group.name = rs.getString("name");
        group.description = rs.getString("description");
        return true;
    }

    public Map<Integer, HCPUser> feedUsers(Collection<Integer> sequences) throws SQLException {
        HashMap<Integer, HCPUser> users = new HashMap<Integer, HCPUser>();
        if (sequences.size() == 0) {
            return users;
        }
        StringBuffer sql = new StringBuffer("SELECT * FROM user WHERE sequence IN (");
        this.appendHolderString(sequences.size(), null, sql);
        sql.append(")");
        ResultSet rs = this.doQuery(sql.toString(), sequences);
        while (rs.next()) {
            users.put(rs.getInt("sequence"), new HCPUser(rs.getInt("sequence"), rs.getString("id"), rs.getString("email"), rs.getString("last_name"), rs.getString("first_name"), rs.getString("organization"), rs.getString("post")));
        }
        return users;
    }

    public boolean belongsTo(HCPUser user, HCPUserGroup group) throws SQLException {
        ResultSet rs = this.doQuery("SELECT user_seq FROM r_user_group WHERE user_seq = ? AND group_seq = ?", user.sequence, group.sequence);
        return rs.next();
    }

    public List<HCPUserGroup> getGroups(int sequence) throws SQLException {
        ResultSet rs = this.doQuery("SELECT g.* FROM user_group AS g INNER JOIN r_user_group AS rug ON g.sequence = rug.group_seq WHERE rug.user_seq = ?", sequence);
        ArrayList<HCPUserGroup> groups = new ArrayList<HCPUserGroup>();
        while (rs.next()) {
            groups.add(new HCPUserGroup(rs.getInt("sequence"), rs.getString("id"), rs.getString("name"), rs.getString("description")));
        }
        return groups;
    }

    public List<HCPUser> getUsers(int groupSeq) throws SQLException {
        ResultSet rs = this.doQuery("SELECT u.* FROM user AS u INNER JOIN r_user_group AS rug ON u.sequence = rug.user_seq WHERE rug.group_seq = ?", groupSeq);
        ArrayList<HCPUser> users = new ArrayList<HCPUser>();
        while (rs.next()) {
            HCPUser user = new HCPUser();
            user.sequence = rs.getInt("sequence");
            user.id = rs.getString("id");
            user.email = rs.getString("email");
            user.lastName = rs.getString("last_name");
            user.firstName = rs.getString("first_name");
            user.organization = rs.getString("organization");
            user.post = rs.getString("post");
            user.disabled = rs.getInt("disabled") > 0;
            users.add(user);
        }
        return users;
    }

    public List<HCPUser> getNotBelongUsers(int groupSeq) throws SQLException {
        ResultSet rs = this.doQuery("SELECT u.* FROM user AS u WHERE NOT EXISTS (SELECT u.sequence FROM r_user_group AS rug WHERE rug.user_seq = u.sequence AND rug.group_seq = ?)", groupSeq);
        ArrayList<HCPUser> users = new ArrayList<HCPUser>();
        while (rs.next()) {
            HCPUser user = new HCPUser();
            user.sequence = rs.getInt("sequence");
            user.id = rs.getString("id");
            user.email = rs.getString("email");
            user.lastName = rs.getString("last_name");
            user.firstName = rs.getString("first_name");
            user.organization = rs.getString("organization");
            user.post = rs.getString("post");
            user.disabled = rs.getInt("disabled") > 0;
            users.add(user);
        }
        return users;
    }

    public List<HCPUser> getUsers(ListAttributes<Sort> attributes) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = "SELECT sequence, id, email, last_name, first_name, organization, post, disabled FROM user ";
        if (attributes.forSort()) {
            sql = String.valueOf(sql) + "ORDER BY ? ";
            params.add(attributes.getSort().toString());
        }
        if (attributes.getLimit() != -1 && attributes.getOffset() != -1) {
            sql = String.valueOf(sql) + "LIMIT ?, ? ";
            params.add(attributes.getOffset());
            params.add(attributes.getLimit());
        }
        ResultSet rs = this.doQuery(sql, params);
        ArrayList<HCPUser> users = new ArrayList<HCPUser>();
        while (rs.next()) {
            HCPUser user = new HCPUser();
            user.sequence = rs.getInt("sequence");
            user.id = rs.getString("id");
            user.email = rs.getString("email");
            user.lastName = rs.getString("last_name");
            user.firstName = rs.getString("first_name");
            user.organization = rs.getString("organization");
            user.post = rs.getString("post");
            user.disabled = rs.getInt("disabled") > 0;
            users.add(user);
        }
        return users;
    }

    public List<HCPUser> getUsers(List<String> userIDs) throws SQLException {
        String sql = "SELECT sequence, id, email, last_name, first_name, organization, post, disabled FROM user WHERE id IN (";
        int i = 0;
        while (i < userIDs.size()) {
            if (i > 0) {
                sql = String.valueOf(sql) + ",";
            }
            sql = String.valueOf(sql) + "?";
            ++i;
        }
        sql = String.valueOf(sql) + ")";
        ResultSet rs = this.doQuery(sql, userIDs);
        ArrayList<HCPUser> users = new ArrayList<HCPUser>();
        while (rs.next()) {
            HCPUser user = new HCPUser();
            user.sequence = rs.getInt("sequence");
            user.id = rs.getString("id");
            user.email = rs.getString("email");
            user.lastName = rs.getString("last_name");
            user.firstName = rs.getString("first_name");
            user.organization = rs.getString("organization");
            user.post = rs.getString("post");
            user.disabled = rs.getInt("disabled") > 0;
            users.add(user);
        }
        return users;
    }

    public List<HCPUserGroup> getUserGroups(int offset, int num) throws SQLException {
        ResultSet rs = this.doQuery("SELECT sequence, id, name, description FROM user_group LIMIT ?, ?", offset, num);
        ArrayList<HCPUserGroup> userGroups = new ArrayList<HCPUserGroup>();
        while (rs.next()) {
            userGroups.add(new HCPUserGroup(rs.getInt("sequence"), rs.getString("id"), rs.getString("name"), rs.getString("description")));
        }
        return userGroups;
    }

    public HCPUser addUser(String email, String password, String lastName, String firstName, String organization, String post, Date now) throws SQLException {
        this.doUpdate("INSERT INTO user (id, email, password, last_name, first_name, organization, post, created) VALUES ('', ?, PASSWORD(?), ?, ?, ?, ?, ?)", email, password, lastName, firstName, organization, post, now);
        int sequence = this.getLastInsertId();
        String id = String.format("%08d", sequence);
        this.doUpdate("UPDATE user SET id = ? WHERE sequence = ?", id, sequence);
        return new HCPUser(sequence, id, email, lastName, firstName, organization, post);
    }

    public HCPUser updateUser(String userID, String email, String password, String lastName, String firstName, String organization, String post) throws SQLException {
        String sql = "UPDATE user SET email = ?, last_name = ?, first_name = ?, organization = ?, post = ?";
        if (password != null && password.length() > 0) {
            sql = String.valueOf(sql) + ",password = PASSWORD(?) ";
            sql = String.valueOf(sql) + " WHERE id = ?";
            this.doUpdate(sql, email, lastName, firstName, organization, post, password, userID);
        } else {
            sql = String.valueOf(sql) + " WHERE id = ?";
            this.doUpdate(sql, email, lastName, firstName, organization, post, userID);
        }
        HCPUser user = new HCPUser();
        user.id = userID;
        user.email = email;
        user.lastName = lastName;
        user.firstName = firstName;
        user.organization = organization;
        user.post = post;
        return user;
    }

    public HCPUserGroup addUserGroup(String name, String description) throws SQLException {
        this.doUpdate("INSERT INTO user_group (id, name, description) VALUES ('', ?, ?)", name, description);
        int sequence = this.getLastInsertId();
        String id = String.format("%08d", sequence);
        this.doUpdate("UPDATE user_group SET id = ? WHERE sequence = ?", id, sequence);
        return new HCPUserGroup(sequence, id, name, description);
    }

    public HCPUserGroup updateGroup(String groupID, String name, String description) throws SQLException {
        String sql = "UPDATE user_group SET name = ?, description = ? ";
        sql = String.valueOf(sql) + " WHERE id = ?";
        this.doUpdate(sql, name, description, groupID);
        HCPUserGroup group = new HCPUserGroup();
        group.id = groupID;
        group.name = name;
        group.description = description;
        return group;
    }

    public void assignGroup(int sequence, Collection<Integer> groups) throws SQLException {
        ResultSet rs = this.doQuery("SELECT group_seq FROM r_user_group WHERE user_seq = ?", sequence);
        HashSet<Integer> belongsTo = new HashSet<Integer>();
        while (rs.next()) {
            belongsTo.add(rs.getInt("group_seq"));
        }
        ArrayList<Integer> newGroups = new ArrayList<Integer>();
        for (Integer groupSeq : groups) {
            if (belongsTo.contains(groupSeq)) continue;
            newGroups.add(groupSeq);
        }
        StringBuffer sql = new StringBuffer("INSERT INTO r_user_group (user_seq, group_seq) VALUES ");
        this.appendValuesHolder(2, newGroups.size(), null, sql);
        ArrayList<Integer> holder = new ArrayList<Integer>();
        for (Integer groupSeq : newGroups) {
            holder.add(sequence);
            holder.add(groupSeq);
        }
        this.doUpdate(sql.toString(), holder);
    }

    public void assignUser(int groupSeq, Collection<Integer> users) throws SQLException {
        ResultSet rs = this.doQuery("SELECT user_seq FROM r_user_group WHERE group_seq = ?", groupSeq);
        HashSet<Integer> includes = new HashSet<Integer>();
        while (rs.next()) {
            includes.add(rs.getInt("user_seq"));
        }
        ArrayList<Integer> newUsers = new ArrayList<Integer>();
        for (Integer sequence : users) {
            if (includes.contains(sequence)) continue;
            newUsers.add(sequence);
        }
        StringBuffer sql = new StringBuffer("INSERT INTO r_user_group (user_seq, group_seq) VALUES ");
        this.appendValuesHolder(2, newUsers.size(), null, sql);
        ArrayList<Integer> holder = new ArrayList<Integer>();
        for (Integer sequence : newUsers) {
            holder.add(sequence);
            holder.add(groupSeq);
        }
        this.doUpdate(sql.toString(), holder);
    }

    public void removeUser(int groupSeq, List<Integer> userIDs) throws SQLException {
        String sql = "DELETE FROM r_user_group WHERE user_seq IN (";
        ArrayList<Integer> holder = new ArrayList<Integer>();
        int i = 0;
        while (i < userIDs.size()) {
            if (i > 0) {
                sql = String.valueOf(sql) + ",";
            }
            sql = String.valueOf(sql) + "?";
            holder.add(userIDs.get(i));
            ++i;
        }
        sql = String.valueOf(sql) + ") AND group_seq = ?";
        holder.add(groupSeq);
        this.doUpdate(sql, holder);
    }

    public int numberOfAllUsers() throws SQLException {
        return this.doCount("SELECT COUNT(sequence) FROM user", new Object[0]);
    }

    public int numberOfAllUserGroups() throws SQLException {
        return this.doCount("SELECT COUNT(sequence) FROM user_group", new Object[0]);
    }

    public void detachUserGroup(int sequence, int groupSeq) throws SQLException {
        this.doUpdate("DELETE FROM r_user_group WHERE user_seq = ? AND group_seq = ?", sequence, groupSeq);
    }

    public void disableUser(int sequence) throws SQLException {
        this.doUpdate("UPDATE user SET disabled = sequence WHERE sequence = ?", sequence);
    }

    public void enableUser(int sequence) throws SQLException {
        this.doUpdate("UPDATE user SET disabled = 0 WHERE sequence = ?", sequence);
    }

    public void deleteGroup(int groupSeq) throws SQLException {
        this.doUpdate("DELETE FROM user_group WHERE sequence = ?", groupSeq);
    }

    public String existUserByEmail(String email) throws SQLException {
        ResultSet rs = this.doQuery("SELECT id FROM user WHERE email = ?", email);
        if (rs.next()) {
            return rs.getString("id");
        }
        return null;
    }

    public boolean existUserGroupByName(String name) throws SQLException {
        return this.doCount("SELECT COUNT(sequence) FROM user_group WHERE name = ?", name) > 0;
    }

    public boolean existUserGroup(String groupID) throws SQLException {
        return this.doCount("SELECT COUNT(sequence) FROM user_group WHERE id = ?", groupID) > 0;
    }

    public boolean existOwnerProject(int groupSeq) throws SQLException {
        return this.doCount("SELECT COUNT(group_seq) FROM r_group_project WHERE group_seq = ? AND owner='y'", groupSeq) > 0;
    }

    public static enum Sort {
        SEQUENCE,
        ID,
        EMAIL,
        FIRST_NAME,
        LAST_NAME,
        ORGANIZATION,
        POST;

    }
}

