/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import jp.ac.nii.hcp.shared.module.BaseProcessor;
import jp.ac.nii.hcp.shared.service.ServiceSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ConnectionService {
    private ServiceSession session = null;
    protected Log log = LogFactory.getLog(this.getClass());

    protected ConnectionService() {
    }

    ServiceSession getSession() {
        return this.session;
    }

    void setSession(ServiceSession session) {
        this.session = session;
    }

    public final <T extends ConnectionService> T self(Class<T> type) {
        return (T)((ConnectionService)type.cast(this));
    }

    protected Connection getConnection() throws SQLException {
        return this.session.getConnection();
    }

    protected <T extends BaseProcessor> T getProcessor(Class<T> type, Object ... args) throws SQLException {
        return BaseProcessor.getProcessor(type, this.getConnection(), args);
    }

    public final void closing() {
        this.session.toClose(true);
    }

    public final void persist() {
        this.session.toClose(false);
    }

    public final void close() {
        this.session.close();
    }

    protected void ok() {
        this.session.mark(true);
    }

    protected <T> T ok(T value) {
        this.session.mark(true);
        return value;
    }

    protected void ng() {
        this.session.mark(false);
    }

    protected <T> T ng(T value) {
        this.session.mark(false);
        return value;
    }

    protected void yield(Object key) {
        this.yield(key, null);
    }

    protected void yield(Object key, Object value) {
        this.session.yield(key, value);
    }

    public final boolean inquire(Object key, Object ... keys) {
        List<Object> records = this.session.inquire(key);
        if (records != null) {
            return true;
        }
        int i = 0;
        while (i < keys.length) {
            records = this.session.inquire(keys[i]);
            if (records != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Object fetch(Object key) {
        List<Object> records = this.session.inquire(key);
        if (records != null) {
            return records.get(0);
        }
        return null;
    }

    public final List<Object> fetchAll(Object key) {
        List<Object> records = this.session.inquire(key);
        return records != null ? records : Arrays.asList(new Object[0]);
    }
}

