/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ac.nii.hcp.shared.jersey.ext.Named;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.HCPUserGroupList;
import jp.ac.nii.hcp.shared.model.HCPUserList;
import jp.ac.nii.hcp.shared.module.ListAttributes;
import jp.ac.nii.hcp.shared.module.UserProcessor;
import jp.ac.nii.hcp.shared.service.ConnectionService;
import jp.ac.nii.hcp.shared.service.ServiceAPI;
import jp.ac.nii.hcp.shared.service.Transactional;
import jp.ac.nii.hcp.shared.validation.NumberOf;
import jp.ac.nii.hcp.shared.validation.Required;
import jp.ac.nii.hcp.shared.validation.StringOf;

public interface UserService
extends ServiceAPI {
    public static final int DEFAULT_GROUP_SEQUENCE = 1;
    public static final String USER_KEY = "USER_INFO";
    public static final String GROUP_KEY = "GROUP_INFO";

    public List<HCPUserGroup> getGroups(@NumberOf(min=1) int var1) throws SQLException;

    public List<HCPUser> getUsers(@StringOf(min=1) String var1, @Required HCPUser var2) throws SQLException;

    public HCPUserList getUsers(@NumberOf(min=1) int var1, @NumberOf(min=1) int var2, String var3, String var4) throws SQLException;

    public List<HCPUser> getUsers(@StringOf(min=1) String var1) throws SQLException;

    public List<HCPUser> getNotBelongUser(@StringOf(min=1) String var1) throws SQLException;

    @Transactional
    public HCPUser registUser(@Required @StringOf(regex="^[a-zA-Z0-9!$&*.=^`|~#%'+\\/?_{}-]+@([a-zA-Z0-9_-]+\\.)+[a-zA-Z]{2,4}$", min=1) @Named(value="email") String var1, @Required @StringOf(regex="^[a-zA-Z0-9]+$", min=4, max=64) @Named(value="password") String var2, @Required @StringOf(regex="[^\\s]+", min=1, max=64) @Named(value="last_name") String var3, @Required @StringOf(regex="[^\\s]+", min=1, max=64) @Named(value="first_name") String var4, @StringOf(max=64) @Named(value="organization") String var5, @StringOf(max=64) @Named(value="post") String var6) throws SQLException;

    @Transactional
    public HCPUser updateUser(@Required String var1, @Required @StringOf(regex="^[a-zA-Z0-9!$&*.=^`|~#%'+\\/?_{}-]+@([a-zA-Z0-9_-]+\\.)+[a-zA-Z]{2,4}$", min=1) @Named(value="email") String var2, String var3, @StringOf(regex="[^\\s]+", min=1, max=64) @Required @Named(value="last_name") String var4, @Required @StringOf(regex="[^\\s]+", min=1, max=64) @Named(value="first_name") String var5, @StringOf(max=64) @Named(value="organization") String var6, @StringOf(max=64) @Named(value="post") String var7) throws SQLException;

    public Map<String, Object> getUser(@StringOf(min=1) String var1) throws SQLException;

    @Transactional
    public boolean disableUser(@StringOf(min=1) String var1) throws SQLException;

    @Transactional
    public boolean enableUser(@StringOf(min=1) String var1) throws SQLException;

    public HCPUserGroupList getUserGroups(@NumberOf(min=1) int var1, @NumberOf(min=1) int var2) throws SQLException;

    public Map<String, Object> getUserGroup(@Required @StringOf(min=1, max=8) String var1) throws SQLException;

    @Transactional
    public HCPUserGroup registGroup(@Required @StringOf(min=3, max=64) @Named(value="group_name") String var1, @StringOf(max=1000) @Named(value="group_desc") String var2) throws SQLException;

    @Transactional
    public HCPUserGroup updateGroup(@Required @StringOf(min=1, max=8) String var1, @Required @StringOf(min=3, max=64) @Named(value="group_name") String var2, @StringOf(min=3, max=64) @Named(value="group_desc") String var3) throws SQLException;

    @Transactional
    public boolean deleteGroup(@Required @StringOf(min=1, max=8) String var1) throws SQLException;

    @Transactional
    public boolean assignUser(@Required @StringOf(min=1, max=8) String var1, @Required List<Integer> var2) throws SQLException;

    @Transactional
    public boolean removeUser(@Required @StringOf(min=1, max=8) String var1, @Required List<Integer> var2) throws SQLException;

    public static class Impl
    extends ConnectionService
    implements UserService {
        public static ListAttributes<UserProcessor.Sort> DEFAULT_USER_ATTRIBUTES = null;

        static {
            DEFAULT_USER_ATTRIBUTES = new ListAttributes<UserProcessor.Sort>(1, UserProcessor.Sort.SEQUENCE, ListAttributes.Order.ASC, 10);
        }

        @Override
        public List<HCPUserGroup> getGroups(int sequence) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            return processor.getGroups(sequence);
        }

        @Override
        public List<HCPUser> getUsers(String groupId, HCPUser user) throws SQLException {
            HCPUserGroup group;
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            if (processor.feedUserGroup(group = new HCPUserGroup(0, groupId, null, null)) && processor.belongsTo(user, group)) {
                return processor.getUsers(group.sequence);
            }
            return null;
        }

        @Override
        public HCPUserList getUsers(int page, int num, String sort, String order) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            int total = processor.numberOfAllUsers();
            if (total == 0) {
                return null;
            }
            if ((page - 1) * num > total) {
                page = 1;
            }
            UserProcessor.Sort s = UserProcessor.Sort.SEQUENCE;
            try {
                s = UserProcessor.Sort.valueOf(sort);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ListAttributes<UserProcessor.Sort> attributes = new ListAttributes<UserProcessor.Sort>(page, s, ListAttributes.ORDER.findValue(order) != null ? ListAttributes.ORDER.findValue(order) : ListAttributes.Order.ASC, num);
            List<HCPUser> users = processor.getUsers(attributes);
            if (users == null || users.size() == 0) {
                return null;
            }
            return new HCPUserList(users, page, total);
        }

        @Override
        public Map<String, Object> getUser(String userID) throws SQLException {
            HCPUser user = new HCPUser();
            user.id = userID;
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            if (!processor.feedUser(user)) {
                this.yield((Object)Status.USER_EXISTS);
                return this.ng(null);
            }
            List<HCPUserGroup> userGroup = processor.getGroups(user.sequence);
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put(UserService.USER_KEY, user);
            userInfo.put(UserService.GROUP_KEY, userGroup);
            return userInfo;
        }

        @Override
        public HCPUser registUser(String email, String password, String lastName, String firstName, String organization, String post) throws SQLException {
            UserProcessor processor;
            if (organization.length() == 0) {
                organization = null;
            }
            if (post.length() == 0) {
                post = null;
            }
            if ((processor = this.getProcessor(UserProcessor.class, new Object[0])).existUserByEmail(email) != null) {
                this.yield((Object)Status.USER_EXISTS);
                return this.ng(null);
            }
            HCPUser user = processor.addUser(email, password, lastName, firstName, organization, post, new Date());
            if (user == null) {
                this.yield((Object)Status.INTERNAL_ERROR);
                return this.ng(null);
            }
            processor.assignGroup(user.sequence, Arrays.asList(1));
            return this.ok(user);
        }

        @Override
        public HCPUser updateUser(String userID, String email, String password, String lastName, String firstName, String organization, String post) throws SQLException {
            UserProcessor processor;
            String duplicatedId;
            if (password.length() == 0 || password.matches("[^\\s]+")) {
                password = null;
            } else if (!password.matches("^[a-zA-Z0-9]+$") || password.length() < 4 || password.length() > 64) {
                this.yield((Object)Status.PASSWORD_VALID_ERROR);
                return this.ng(null);
            }
            if (organization.length() == 0) {
                organization = null;
            }
            if (post.length() == 0) {
                post = null;
            }
            if (!userID.equals(duplicatedId = (processor = this.getProcessor(UserProcessor.class, new Object[0])).existUserByEmail(email))) {
                this.yield((Object)Status.USER_EXISTS);
                return this.ng(null);
            }
            HCPUser user = new HCPUser();
            user.id = userID;
            if (!processor.feedUser(user)) {
                this.yield((Object)Status.USER_NOT_EXIST);
                return this.ng(null);
            }
            if (user.disabled) {
                this.yield((Object)Status.INOPERABLE);
                return this.ng(null);
            }
            return processor.updateUser(userID, email, password, lastName, firstName, organization, post);
        }

        @Override
        public boolean disableUser(String userID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUser user = new HCPUser();
            user.id = userID;
            if (!processor.feedUser(user)) {
                this.yield((Object)Status.USER_NOT_EXIST);
                return this.ng(false);
            }
            if (user.disabled) {
                this.yield((Object)Status.INOPERABLE);
                return this.ng(false);
            }
            processor.disableUser(user.sequence);
            return this.ok(true);
        }

        @Override
        public boolean enableUser(String userID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUser user = new HCPUser();
            user.id = userID;
            if (!processor.feedUser(user)) {
                this.yield((Object)Status.USER_NOT_EXIST);
                return this.ng(false);
            }
            if (!user.disabled) {
                this.yield((Object)Status.OPERABLE);
                return this.ng(false);
            }
            processor.enableUser(user.sequence);
            return this.ok(true);
        }

        @Override
        public HCPUserGroupList getUserGroups(int page, int num) throws SQLException {
            List<HCPUserGroup> groups;
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            int total = processor.numberOfAllUserGroups();
            if (total == 0) {
                return null;
            }
            if ((page - 1) * num > total) {
                page = 1;
            }
            if ((groups = processor.getUserGroups((page - 1) * num, num)) == null || groups.size() == 0) {
                return null;
            }
            return new HCPUserGroupList(groups, page, total);
        }

        @Override
        public Map<String, Object> getUserGroup(String groupID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(null);
            }
            List<HCPUser> users = processor.getUsers(group.sequence);
            HashMap<String, Object> userGroups = new HashMap<String, Object>();
            userGroups.put(UserService.GROUP_KEY, group);
            userGroups.put(UserService.USER_KEY, users);
            return userGroups;
        }

        @Override
        public HCPUserGroup registGroup(String name, String description) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            if (processor.existUserGroupByName(name)) {
                this.yield((Object)Status.GROUP_EXISTS);
                return this.ng(null);
            }
            return processor.addUserGroup(name, description);
        }

        @Override
        public HCPUserGroup updateGroup(String groupID, String name, String description) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            if (!processor.existUserGroup(groupID)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return null;
            }
            return processor.updateGroup(groupID, name, description);
        }

        @Override
        public boolean deleteGroup(String groupID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(false);
            }
            if (processor.getUsers(group.sequence).size() > 0) {
                this.yield((Object)Status.USER_EXISTS);
                return this.ng(false);
            }
            if (processor.existOwnerProject(group.sequence)) {
                this.yield((Object)Status.OWNERED_PROJECT_EXISTS);
                return this.ng(false);
            }
            processor.deleteGroup(group.sequence);
            return true;
        }

        @Override
        public boolean assignUser(String groupID, List<Integer> userIDs) throws SQLException {
            if (userIDs.size() == 0) {
                this.yield((Object)Status.USER_NOT_EXIST);
                return this.ng(false);
            }
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(false);
            }
            processor.assignUser(group.sequence, userIDs);
            return this.ok(true);
        }

        @Override
        public List<HCPUser> getUsers(String groupID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(null);
            }
            return processor.getUsers(group.sequence);
        }

        @Override
        public List<HCPUser> getNotBelongUser(String groupID) throws SQLException {
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(null);
            }
            return processor.getNotBelongUsers(group.sequence);
        }

        @Override
        public boolean removeUser(@Required @StringOf(min=1, max=8) String groupID, @Required List<Integer> userIDs) throws SQLException {
            if (userIDs.size() == 0) {
                this.yield((Object)Status.USER_NOT_EXIST);
                return this.ng(false);
            }
            UserProcessor processor = this.getProcessor(UserProcessor.class, new Object[0]);
            HCPUserGroup group = new HCPUserGroup();
            group.id = groupID;
            if (!processor.feedUserGroup(group)) {
                this.yield((Object)Status.GROUP_NOT_FOUND);
                return this.ng(false);
            }
            processor.removeUser(group.sequence, userIDs);
            return this.ok(true);
        }
    }

    public static enum Status {
        USER_EXISTS,
        USER_NOT_EXIST,
        OPERABLE,
        INOPERABLE,
        INTERNAL_ERROR,
        GROUP_EXISTS,
        GROUP_NOT_FOUND,
        OWNERED_PROJECT_EXISTS,
        PASSWORD_VALID_ERROR;

    }
}

