/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.shared.service.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jp.ac.nii.hcp.shared.service.ConnectionService;
import jp.ac.nii.hcp.shared.service.ServiceAPI;
import jp.ac.nii.hcp.shared.service.ServiceSession;
import jp.ac.nii.hcp.shared.service.ServiceValidationException;
import jp.ac.nii.hcp.shared.validation.NumberOf;
import jp.ac.nii.hcp.shared.validation.Required;
import jp.ac.nii.hcp.shared.validation.Size;
import jp.ac.nii.hcp.shared.validation.StringOf;
import jp.ac.nii.hcp.shared.validation.Validate;
import jp.ac.nii.hcp.shared.validation.ValidateMethod;

public class ValidationTest {
    private static final int MIN_STR = 2;
    private static final int MAX_STR = 3;
    private static final String REG_STR = "^a.*";
    private static final int MIN_INT = 0;
    private static final int MAX_INT = 10;
    private static final double MIN_DBL = 0.0;
    private static final double MAX_DBL = 10.0;
    private static final int MIN_SIZE = 2;
    private static final int MAX_SIZE = 3;

    public static void main(String[] args) throws Exception {
        TestService service = ServiceSession.openService(TestService.class);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.print("command > ");
                String command = reader.readLine();
                if (ValidationTest.is(command, "sreq", "string required")) {
                    System.out.println("Empty to null");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "smin", "string minimum")) {
                    System.out.println("min = 2");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "smax", "string maximum")) {
                    System.out.println("max = 3");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "sreg", "string regex")) {
                    System.out.println("regex = ^a.*");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "imin", "integer minimum")) {
                    System.out.println("min = 0");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "imax", "integer maximum")) {
                    System.out.println("max = 10");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "dmin", "double minimum")) {
                    System.out.println("min = 0.0");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "dmax", "double maximum")) {
                    System.out.println("max = 10.0");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "ssize_min", "string array size minimum")) {
                    System.out.println("min = 2");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "ssize_max", "string array size maximum")) {
                    System.out.println("max = 3");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "ssmin", "string array minimum")) {
                    System.out.println("min = 2");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "ssmax", "string array maximum")) {
                    System.out.println("max = 3");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "isize_min", "integer array size minimum")) {
                    System.out.println("min = 2");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "isize_max", "integer array size maximum")) {
                    System.out.println("max = 3");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "iimin", "integer array minimum")) {
                    System.out.println("min = 0");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (ValidationTest.is(command, "iimax", "integer array maximum")) {
                    System.out.println("max = 10");
                    ValidationTest.exec(command, service, reader);
                    continue;
                }
                if (!ValidationTest.is(command, "object", "object class validation")) continue;
                System.out.println(String.format("object 'null' is null / string min = %d, max = %d, regex = %s / integer min = %d, max = %d", 2, 3, REG_STR, 0, 10));
                ValidationTest.exec(command, service, reader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static boolean is(String command, String tobe, String output) {
        if (command != null && command.equals(tobe)) {
            System.out.println(output);
            return true;
        }
        return false;
    }

    private static void exec(String command, TestService service, BufferedReader reader) throws IOException {
        try {
            System.out.print("input > ");
            String arg = reader.readLine();
            if (command.equals("sreq")) {
                service.sreq(arg.length() > 0 ? arg : null);
            } else if (command.equals("smin")) {
                service.smin(arg);
            } else if (command.equals("smax")) {
                service.smax(arg);
            } else if (command.equals("sreg")) {
                service.sreg(arg);
            } else if (command.equals("imin")) {
                service.imin(Integer.parseInt(arg));
            } else if (command.equals("imax")) {
                service.imax(Integer.parseInt(arg));
            } else if (command.equals("dmin")) {
                service.dmin(Double.parseDouble(arg));
            } else if (command.equals("dmax")) {
                service.dmax(Double.parseDouble(arg));
            } else if (command.equals("ssize_min")) {
                service.ssize_min(arg.split(" "));
            } else if (command.equals("ssize_max")) {
                service.ssize_max(arg.split(" "));
            } else if (command.equals("ssmin")) {
                service.ssmin(arg.split(" "));
            } else if (command.equals("ssmax")) {
                service.ssmax(arg.split(" "));
            } else if (command.equals("isize_min")) {
                String[] args = arg.split(" ");
                int[] ii = new int[args.length];
                int i = 0;
                while (i < args.length) {
                    ii[i] = Integer.parseInt(args[i]);
                    ++i;
                }
                service.isize_min(ii);
            } else if (command.equals("isize_max")) {
                String[] args = arg.split(" ");
                int[] ii = new int[args.length];
                int i = 0;
                while (i < args.length) {
                    ii[i] = Integer.parseInt(args[i]);
                    ++i;
                }
                service.isize_max(ii);
            } else if (command.equals("iimin")) {
                String[] args = arg.split(" ");
                int[] ii = new int[args.length];
                int i = 0;
                while (i < args.length) {
                    ii[i] = Integer.parseInt(args[i]);
                    ++i;
                }
                service.iimin(ii);
            } else if (command.equals("iimax")) {
                String[] args = arg.split(" ");
                int[] ii = new int[args.length];
                int i = 0;
                while (i < args.length) {
                    ii[i] = Integer.parseInt(args[i]);
                    ++i;
                }
                service.iimax(ii);
            } else if (command.equals("object")) {
                String[] args = arg.split(" ");
                Child c = new Child(args[0].equals("null") ? null : args[0], args[1], Integer.parseInt(args[2]));
                service.object(c);
            }
            System.out.println("OK");
        }
        catch (ServiceValidationException e) {
            System.out.println("NG");
        }
    }

    @Validate
    public static class Child
    extends Parent {
        @NumberOf(min=0, max=10)
        private int i;

        public Child(Object o, String s, int i) {
            super(o, s);
            this.i = i;
        }

        @ValidateMethod
        private boolean validate1() {
            return super.validate();
        }

        @ValidateMethod
        private boolean validate2() {
            return this.i > 5 && this.i < 9;
        }
    }

    @Validate
    public static class Parent {
        @Required
        private Object po;
        @StringOf(min=2, max=3, regex="^a.*")
        private String ps;

        public Parent(Object po, String ps) {
            this.po = po;
            this.ps = ps;
        }

        public boolean validate() {
            return this.ps.startsWith("ab");
        }
    }

    public static interface TestService
    extends ServiceAPI {
        public void sreq(@Required String var1);

        public void smin(@StringOf(min=2) String var1);

        public void smax(@StringOf(max=3) String var1);

        public void sreg(@StringOf(regex="^a.*") String var1);

        public void imin(@NumberOf(min=0) int var1);

        public void imax(@NumberOf(max=10) int var1);

        public void dmin(@NumberOf(rmin=0.0) double var1);

        public void dmax(@NumberOf(rmax=10.0) double var1);

        public void ssize_min(@Size(min=2) String[] var1);

        public void ssize_max(@Size(max=3) String[] var1);

        public void isize_min(@Size(min=2) int[] var1);

        public void isize_max(@Size(max=3) int[] var1);

        public void ssmin(@StringOf(min=2) String[] var1);

        public void ssmax(@StringOf(max=3) String[] var1);

        public void ssreg(@StringOf(regex="^a.*") String[] var1);

        public void iimin(@NumberOf(min=0) int[] var1);

        public void iimax(@NumberOf(max=10) int[] var1);

        public void object(@Validate Object var1);

        public static class Impl
        extends ConnectionService
        implements TestService {
            @Override
            public void sreq(@Required String str) {
            }

            @Override
            public void smin(@StringOf(min=2) String str) {
            }

            @Override
            public void smax(@StringOf(max=3) String str) {
            }

            @Override
            public void sreg(@StringOf(regex="^a.*") String str) {
            }

            @Override
            public void imin(@NumberOf(min=0) int i) {
            }

            @Override
            public void imax(@NumberOf(max=10) int i) {
            }

            @Override
            public void dmin(@NumberOf(rmin=0.0) double d) {
            }

            @Override
            public void dmax(@NumberOf(rmax=10.0) double d) {
            }

            @Override
            public void ssize_min(@Size(min=2) String[] ss) {
            }

            @Override
            public void ssize_max(@Size(max=3) String[] ss) {
            }

            @Override
            public void isize_min(@Size(min=2) int[] ii) {
            }

            @Override
            public void isize_max(@Size(max=3) int[] ii) {
            }

            @Override
            public void ssmin(@StringOf(min=2) String[] ss) {
            }

            @Override
            public void ssmax(@StringOf(max=3) String[] ss) {
            }

            @Override
            public void ssreg(@StringOf(regex="^a.*") String[] ss) {
            }

            @Override
            public void iimin(@NumberOf(min=0) int[] i) {
            }

            @Override
            public void iimax(@NumberOf(max=10) int[] i) {
            }

            @Override
            public void object(@Validate Object obj) {
            }
        }
    }
}

