/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.IOException;
import java.io.InputStream;
import jp.ac.nii.hcp.client.net.ImageClient;
import jp.ac.nii.hcp.client.net.ImageDownloader;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.ImageSpace;
import jp.ac.nii.hcp.shared.model.HCPImage;
import jp.ac.nii.hcp.shared.model.HCPImageList;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;

public class ImageContentManager {
    private ImageSpace space;
    private ImageClient client;

    public ImageContentManager(ImageSpace space, ClientConfiguration config) {
        this.space = space;
        this.client = new ImageClient(config);
    }

    public boolean exists(String path) {
        return this.space.exists(path);
    }

    public HCPImage fetch(String ownerCode, String imageCode) throws IOException {
        HCPImage image = new HCPImage(ownerCode, imageCode, null, null, null);
        return this.client.fetch(image.getPath());
    }

    public HCPImage fetch(String path) throws IOException {
        return this.client.fetch(path);
    }

    public HCPImageList search(String id, Integer page, Integer limit) throws IOException {
        return this.client.search(id, page, limit);
    }

    public HCPImage add(HCPUser user, String code, String url) throws IOException, HCPClientException {
        return this.add(new HCPImage(user.id, code, HCPImage.OwnerType.USER, url, null), url);
    }

    public HCPImage add(HCPUserGroup group, String code, String url) throws IOException, HCPClientException {
        return this.add(new HCPImage(group.id, code, HCPImage.OwnerType.GROUP, url, null), url);
    }

    private HCPImage add(HCPImage image, String url) throws IOException, HCPClientException {
        if (image.validateRegistration()) {
            this.client.add(image);
            return this.fetch(image.owner_code, image.image_code);
        }
        throw new HCPClientException(ClientStatus.IMAGE_NOT_AVAILABLE, String.format("Owner code %s or image code %s is not available", image.owner_code, image.image_code), null);
    }

    public HCPImage download(String path, ImageDownloader downloader) throws IOException {
        HCPImage image = this.client.fetch(path);
        if (image != null) {
            if (downloader == null) {
                downloader = ImageDownloader.Default.INSTANCE;
            }
            InputStream stream = downloader.execute(image.url);
            String ext = this.urlToExt(image.url);
            if (ext != null) {
                path = String.valueOf(path) + "." + ext;
            }
            this.space.saveImage(path, stream);
            stream.close();
            return image;
        }
        return null;
    }

    private String urlToExt(String url) {
        int extPos = url.lastIndexOf(46);
        int sepPos = url.lastIndexOf(47);
        if (extPos >= 0 && extPos > sepPos && extPos < url.length() - 1) {
            return url.substring(extPos + 1);
        }
        return null;
    }
}

