/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.hcp.client.core;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ac.nii.hcp.client.core.FileAttachmentManager;
import jp.ac.nii.hcp.client.core.ImageContentManager;
import jp.ac.nii.hcp.client.core.StandaloneWorkspaceController;
import jp.ac.nii.hcp.client.net.AuthenticationCache;
import jp.ac.nii.hcp.client.net.AuthenticationClient;
import jp.ac.nii.hcp.client.net.ImageDownloader;
import jp.ac.nii.hcp.client.net.ProjectClient;
import jp.ac.nii.hcp.client.net.ProjectContentClient;
import jp.ac.nii.hcp.client.net.RepositoryConnection;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.ClientConfiguration;
import jp.ac.nii.hcp.client.shared.ClientStatus;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.client.workspace.ProjectSpace;
import jp.ac.nii.hcp.client.workspace.RepositorySpace;
import jp.ac.nii.hcp.client.workspace.Workspace;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.HCPProjectHistory;
import jp.ac.nii.hcp.shared.model.HCPProjectList;
import jp.ac.nii.hcp.shared.model.HCPProjectMember;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.HCPUserGroup;
import jp.ac.nii.hcp.shared.model.OAuthToken;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

public class SynchronizedWorkspaceController
extends StandaloneWorkspaceController {
    private RepositoryConnection connection = new RepositoryConnection();
    private ProjectClient projectClient;
    private ImageContentManager imageManager;
    private ClientConfiguration config;

    protected SynchronizedWorkspaceController(Workspace ws, ClientConfiguration config) {
        super(ws);
        this.config = config;
        this.projectClient = new ProjectClient(this.connection, this.config);
        this.imageManager = new ImageContentManager(this.workspace.getImageSpace(), this.config);
    }

    protected RepositoryConnection getConnection() {
        return this.connection;
    }

    protected ClientConfiguration getConfiguration() {
        return this.config;
    }

    public ImageContentManager getImageManager() {
        return this.imageManager;
    }

    public FileAttachmentManager getAttachmentManager(String name) throws HCPClientException {
        ProjectContentClient contentClient = new ProjectContentClient(name, this.connection, this.config);
        FileAttachmentManager manager = new FileAttachmentManager(contentClient);
        ProjectSpace space = this.workspace.getRepositorySpace().getProjectSpace(name);
        if (space != null) {
            manager.setSpace(space);
            return manager;
        }
        throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace", name), null);
    }

    public boolean authenticated() {
        OAuthToken token = this.workspace.getAuthSpace().getStoredToken();
        return token != null;
    }

    public AuthenticationCache login() throws IOException {
        AuthenticationClient client = new AuthenticationClient(this.connection, this.config);
        OAuthToken token = this.workspace.getAuthSpace().getStoredToken();
        if (token != null) {
            return client.checkToken(token);
        }
        return null;
    }

    public AuthenticationCache login(String email, String password) throws IOException {
        AuthenticationClient client = new AuthenticationClient(this.connection, this.config);
        AuthenticationCache auth = client.login(email, password);
        if (auth != null) {
            this.workspace.getAuthSpace().storeToken(auth.token);
        }
        return auth;
    }

    public void logout() throws IOException, UnauthorizedException {
        AuthenticationClient client = new AuthenticationClient(this.connection, this.config);
        client.logout();
        this.workspace.getAuthSpace().deleteToken();
    }

    public List<HCPUserGroup> getGroups(AuthenticationCache auth) throws IOException, UnauthorizedException {
        AuthenticationClient client = new AuthenticationClient(this.connection, this.config);
        return client.getGroups(auth);
    }

    public List<HCPUser> getUsers(String groupId) throws IOException, UnauthorizedException {
        AuthenticationClient client = new AuthenticationClient(this.connection, this.config);
        return client.getUsers(groupId);
    }

    public void setAccessibility(String name, HCPProject.Accessibility accessibility) throws IOException, UnauthorizedException {
        this.projectClient.setAccessibility(name, accessibility);
    }

    public List<HCPProjectMember> getMembers(String name) throws IOException, UnauthorizedException {
        return this.projectClient.getMembers(name);
    }

    public boolean setMember(String name, String groupId, HCPProject.GroupPermission permission) throws IOException, UnauthorizedException {
        return this.projectClient.setMember(name, groupId, permission);
    }

    public void deleteMember(String name, String groupId) throws IOException, UnauthorizedException {
        this.projectClient.deleteMember(name, groupId);
    }

    public HCPProjectList searchProjects() throws IOException, UnauthorizedException {
        return this.projectClient.list(null, null);
    }

    public HCPProjectList searchProjects(int page) throws IOException, UnauthorizedException {
        return this.projectClient.list(page > 0 ? Integer.valueOf(page) : null, null);
    }

    public HCPProjectList searchProjects(int page, int limit) throws IOException, UnauthorizedException {
        return this.projectClient.list(page > 0 ? Integer.valueOf(page) : null, limit > 0 ? Integer.valueOf(limit) : null);
    }

    public boolean exists(String name) throws IOException, UnauthorizedException {
        return this.fetchProject(name) != null;
    }

    public HCPProject fetchProject(String name) throws IOException, UnauthorizedException {
        return this.fetchProject(name, 0);
    }

    public HCPProject fetchProject(String name, int revision) throws IOException, UnauthorizedException {
        return this.projectClient.get(name, revision);
    }

    public HCPMaterial fetchMaterial(String name, String id) throws IOException, UnauthorizedException, HCPClientException {
        ProjectContentClient contentClient = new ProjectContentClient(name, this.connection, this.config);
        return contentClient.fetchMaterial(id);
    }

    public HCPDocument fetchDocument(String name, String id) throws IOException, UnauthorizedException, HCPClientException {
        return this.fetchDocument(name, id, 0);
    }

    public HCPDocument fetchDocument(String name, String id, int revision) throws IOException, UnauthorizedException, HCPClientException {
        ProjectContentClient contentClient = new ProjectContentClient(name, this.connection, this.config);
        return contentClient.fetchDocument(id, revision);
    }

    public HCPAttachment fetchAttachment(String name, String id) throws IOException, UnauthorizedException, HCPClientException {
        ProjectContentClient contentClient = new ProjectContentClient(name, this.connection, this.config);
        return contentClient.fetchAttachment(id);
    }

    public HCPProject importProject(String name, String groupId) throws IOException, UnauthorizedException, HCPClientException {
        RepositorySpace space = this.workspace.getRepositorySpace();
        if (space.hasProject(name)) {
            try {
                HCPProject project = space.getProject(name);
                ProjectSpace projectSpace = space.getProjectSpace(name);
                ArrayList<File> attachmentFiles = new ArrayList<File>();
                for (HCPAttachment attachment : project.attachments) {
                    File attachmentFile = projectSpace.getAttachmentFile(attachment);
                    if (attachmentFile == null || !attachmentFile.exists()) continue;
                    attachmentFiles.add(attachmentFile);
                }
                HCPProject imported = this.projectClient.add(project, groupId, attachmentFiles);
                projectSpace.applyImport(imported);
                return imported;
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'", name), e);
            }
        }
        throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace", name), null);
    }

    public void deleteProject(String name) throws IOException, UnauthorizedException {
        this.projectClient.delete(name);
        RepositorySpace space = this.workspace.getRepositorySpace();
        space.removeProject(name);
    }

    public HCPProject exportProject(String name, String newName) throws IOException, UnauthorizedException, HCPClientException {
        return this.exportProject(name, 0, newName);
    }

    public HCPProject exportProject(String name, int revision, String newName) throws IOException, UnauthorizedException, HCPClientException {
        return this.exportProject(name, revision, newName, null);
    }

    public HCPProject exportProject(String name, int revision, String newName, ImageDownloader downloader) throws IOException, UnauthorizedException, HCPClientException {
        if (!HCPProject.validateName((String)newName)) {
            throw new HCPClientException(ClientStatus.PROJECT_NAME_INVALID, String.format("'%s' is unavailable as project name.", newName), null);
        }
        RepositorySpace repositorySpace = this.workspace.getRepositorySpace();
        if (!repositorySpace.hasProject(newName)) {
            HCPProject project = this.fetchProject(name, revision);
            if (project != null) {
                project.name = newName;
                try {
                    HCPProject exported = repositorySpace.createProject(project, true);
                    this.downloadImages(project.materials, downloader);
                    this.downloadAttachments(name, repositorySpace.getProjectSpace(newName), project.attachments);
                    return exported;
                }
                catch (SQLException e) {
                    throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'", newName), e);
                }
            }
            throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in repository.", name), null);
        }
        throw new HCPClientException(ClientStatus.PROJECT_ALREADY_EXISTS, String.format("Project '%s' already exists in workspace.", newName), null);
    }

    public HCPProject checkoutProject(String name) throws IOException, UnauthorizedException, HCPClientException {
        return this.checkoutProject(name, 0, null);
    }

    public HCPProject checkoutProject(String name, int revision) throws IOException, UnauthorizedException, HCPClientException {
        return this.checkoutProject(name, revision, null);
    }

    public HCPProject checkoutProject(String name, int revision, ImageDownloader downloader) throws IOException, UnauthorizedException, HCPClientException {
        RepositorySpace repositorySpace = this.workspace.getRepositorySpace();
        if (!repositorySpace.hasProject(name)) {
            HCPProject project = this.fetchProject(name, revision);
            try {
                if (project != null) {
                    HCPProject checkouted = repositorySpace.createProject(project, false);
                    this.downloadImages(project.materials, downloader);
                    this.downloadAttachments(name, repositorySpace.getProjectSpace(name), project.attachments);
                    return checkouted;
                }
                throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in repository.", name), null);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'", name), e);
            }
        }
        throw new HCPClientException(ClientStatus.PROJECT_ALREADY_EXISTS, String.format("Project '%s' already exists in workspace.", name), null);
    }

    public HCPProject updateProject(String name, boolean overwrite, Collection<HCPProjectContent> edited) throws IOException, UnauthorizedException, HCPClientException {
        return this.updateProject(name, null, overwrite, edited, null);
    }

    public HCPProject updateProject(String name, Set<String> ids, boolean overwrite, Collection<HCPProjectContent> edited) throws IOException, UnauthorizedException, HCPClientException {
        return this.updateProject(name, ids, overwrite, edited, null);
    }

    public HCPProject updateProject(String name, Set<String> ids, boolean overwrite, Collection<HCPProjectContent> edited, ImageDownloader downloader) throws IOException, UnauthorizedException, HCPClientException {
        RepositorySpace repositorySpace = this.workspace.getRepositorySpace();
        if (repositorySpace.hasProject(name)) {
            ProjectSpace projectSpace = repositorySpace.getProjectSpace(name);
            try {
                HCPProject project = this.fetchProject(name);
                if (project != null) {
                    Collection<HCPProjectContent> failed = repositorySpace.updateProject(name, project, ids, overwrite);
                    if (edited != null) {
                        edited.addAll(failed);
                    }
                    this.downloadImages(project.materials, downloader);
                    this.downloadAttachments(name, projectSpace, project.attachments);
                    return project;
                }
                throw new HCPClientException(ClientStatus.PROJECT_ALREADY_DELETED, String.format("Project '%s' is already deleted in repository.", name), null);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, String.format("SQLite access error in project '%s'", name), e);
            }
        }
        throw new HCPClientException(ClientStatus.PROJECT_NOT_FOUND, String.format("Project '%s' does not exist in workspace.", name), null);
    }

    public ProjectDifference commitProject(String name, String comment, boolean force) throws IOException, UnauthorizedException, HCPClientException {
        ProjectDifference diff = this.status(name);
        if (diff.contains()) {
            ProjectDifference committed = this.projectClient.commit(name, diff, comment, force);
            ProjectSpace space = this.workspace.getRepositorySpace().getProjectSpace(name);
            try {
                space.applyCommit(committed);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
            }
        }
        return diff;
    }

    public ProjectDifference commitProject(String name, Iterable<String> ids, String comment, boolean force) throws IOException, UnauthorizedException, HCPClientException {
        ProjectDifference diff = this.status(name);
        HashSet<String> idSet = new HashSet<String>();
        for (String id : ids) {
            idSet.add(id);
        }
        this.selectContents(idSet, diff.added);
        this.selectContents(idSet, diff.modified);
        this.selectContents(idSet, diff.deleted);
        if (diff.contains()) {
            ProjectDifference committed = this.projectClient.commit(name, diff, comment, force);
            ProjectSpace space = this.workspace.getRepositorySpace().getProjectSpace(name);
            try {
                space.applyCommit(committed);
            }
            catch (SQLException e) {
                throw new HCPClientException(ClientStatus.DB_ERROR, "SQLite access error.", e);
            }
        }
        return diff;
    }

    public List<HCPProjectHistory> fetchHistories(String name, int from, int to) throws IOException, UnauthorizedException {
        return this.projectClient.getHistories(name, from, to);
    }

    private boolean downloadImages(Collection<HCPMaterial> materials, ImageDownloader downloader) {
        boolean status = true;
        for (HCPMaterial material : materials) {
            if (this.imageManager.exists(material.imagePath)) continue;
            try {
                this.imageManager.download(material.imagePath, downloader);
            }
            catch (IOException e) {
                status = false;
            }
        }
        return status;
    }

    private void downloadAttachments(String name, ProjectSpace space, Collection<HCPAttachment> attachments) throws IOException, UnauthorizedException, HCPClientException {
        ProjectContentClient contentClient = new ProjectContentClient(name, this.connection, this.config);
        FileAttachmentManager manager = new FileAttachmentManager(contentClient);
        manager.setSpace(space);
        manager.download(attachments);
    }

    private void selectContents(Set<String> idSet, List<HCPProjectContent> contents) {
        int size = contents.size();
        int i = 0;
        while (i < size) {
            if (!idSet.contains(contents.get((int)i).id)) {
                contents.remove(i);
                --size;
                continue;
            }
            ++i;
        }
    }
}

